/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.joyqueue.network.command.FetchIndexRequest;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;

public class FetchIndexRequestCodec
implements PayloadCodec<JoyQueueHeader, FetchIndexRequest>,
Type {
    public FetchIndexRequest decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        HashMap result = Maps.newHashMap();
        int topicSize = buffer.readShort();
        for (int i = 0; i < topicSize; ++i) {
            String topic = Serializer.readString(buffer, 2);
            int partitionSize = buffer.readShort();
            LinkedList partitions = Lists.newLinkedList();
            for (int j = 0; j < partitionSize; ++j) {
                partitions.add(buffer.readShort());
            }
            result.put(topic, partitions);
        }
        FetchIndexRequest fetchIndexRequest = new FetchIndexRequest();
        fetchIndexRequest.setPartitions(result);
        fetchIndexRequest.setApp(Serializer.readString(buffer, 2));
        return fetchIndexRequest;
    }

    @Override
    public void encode(FetchIndexRequest payload, ByteBuf buffer) throws Exception {
        buffer.writeShort(payload.getPartitions().size());
        for (Map.Entry<String, List<Short>> entry : payload.getPartitions().entrySet()) {
            Serializer.write(entry.getKey(), buffer, 2);
            buffer.writeShort(entry.getValue().size());
            for (Short partition : entry.getValue()) {
                buffer.writeShort((int)partition.shortValue());
            }
        }
        Serializer.write(payload.getApp(), buffer, 2);
    }

    @Override
    public int type() {
        return JoyQueueCommandType.FETCH_INDEX_REQUEST.getCode();
    }
}

