/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.FetchIndexData;
import org.joyqueue.network.command.FetchIndexResponse;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;

public class FetchIndexResponseCodec
implements PayloadCodec<JoyQueueHeader, FetchIndexResponse>,
Type {
    public FetchIndexResponse decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        HashBasedTable result = HashBasedTable.create();
        int topicSize = buffer.readShort();
        for (int i = 0; i < topicSize; ++i) {
            String topic = Serializer.readString(buffer, 2);
            int partitionSize = buffer.readShort();
            for (int j = 0; j < partitionSize; ++j) {
                short partition = buffer.readShort();
                long index = buffer.readLong();
                JoyQueueCode code = JoyQueueCode.valueOf((int)buffer.readInt());
                long leftIndex = -1L;
                long rightIndex = -1L;
                if (header.getVersion() >= 3) {
                    leftIndex = buffer.readLong();
                    rightIndex = buffer.readLong();
                }
                FetchIndexData fetchIndexData = new FetchIndexData(index, leftIndex, rightIndex, code);
                result.put((Object)topic, (Object)partition, (Object)fetchIndexData);
            }
        }
        FetchIndexResponse fetchIndexResponse = new FetchIndexResponse();
        fetchIndexResponse.setData((Table<String, Short, FetchIndexData>)result);
        return fetchIndexResponse;
    }

    @Override
    public void encode(FetchIndexResponse payload, ByteBuf buffer) throws Exception {
        buffer.writeShort(payload.getData().rowMap().size());
        for (Map.Entry topicEntry : payload.getData().rowMap().entrySet()) {
            Serializer.write((String)topicEntry.getKey(), buffer, 2);
            buffer.writeShort(((Map)topicEntry.getValue()).size());
            for (Map.Entry partitionEntry : ((Map)topicEntry.getValue()).entrySet()) {
                FetchIndexData fetchIndexData = (FetchIndexData)partitionEntry.getValue();
                buffer.writeShort((int)((Short)partitionEntry.getKey()).shortValue());
                buffer.writeLong(fetchIndexData.getIndex());
                buffer.writeInt(fetchIndexData.getCode().getCode());
                if (payload.getHeader().getVersion() < 3) continue;
                buffer.writeLong(fetchIndexData.getLeftIndex());
                buffer.writeLong(fetchIndexData.getRightIndex());
            }
        }
    }

    @Override
    public int type() {
        return JoyQueueCommandType.FETCH_INDEX_RESPONSE.getCode();
    }
}

