/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.FetchProduceFeedbackAckData;
import org.joyqueue.network.command.FetchProduceFeedbackResponse;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;

public class FetchProduceFeedbackResponseCodec
implements PayloadCodec<JoyQueueHeader, FetchProduceFeedbackResponse>,
Type {
    public FetchProduceFeedbackResponse decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        int dataSize = buffer.readShort();
        ArrayList data = Lists.newArrayListWithCapacity((int)dataSize);
        for (int i = 0; i < dataSize; ++i) {
            String topic = Serializer.readString(buffer, 2);
            String txId = Serializer.readString(buffer, 2);
            String transactionId = Serializer.readString(buffer, 2);
            data.add(new FetchProduceFeedbackAckData(topic, txId, transactionId));
        }
        FetchProduceFeedbackResponse fetchProduceFeedbackResponse = new FetchProduceFeedbackResponse();
        fetchProduceFeedbackResponse.setData(data);
        fetchProduceFeedbackResponse.setCode(JoyQueueCode.valueOf((int)buffer.readInt()));
        return fetchProduceFeedbackResponse;
    }

    @Override
    public void encode(FetchProduceFeedbackResponse payload, ByteBuf buffer) throws Exception {
        buffer.writeShort(payload.getData().size());
        for (FetchProduceFeedbackAckData data : payload.getData()) {
            Serializer.write(data.getTopic(), buffer, 2);
            Serializer.write(data.getTxId(), buffer, 2);
            Serializer.write(data.getTransactionId(), buffer, 2);
        }
        buffer.writeInt(payload.getCode().getCode());
    }

    @Override
    public int type() {
        return JoyQueueCommandType.FETCH_PRODUCE_FEEDBACK_RESPONSE.getCode();
    }
}

