/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import org.joyqueue.network.command.FindCoordinatorRequest;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;

public class FindCoordinatorRequestCodec
implements PayloadCodec<JoyQueueHeader, FindCoordinatorRequest>,
Type {
    public FindCoordinatorRequest decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        FindCoordinatorRequest findCoordinatorRequest = new FindCoordinatorRequest();
        int topicSize = buffer.readShort();
        ArrayList topics = Lists.newArrayListWithCapacity((int)topicSize);
        for (int i = 0; i < topicSize; ++i) {
            topics.add(Serializer.readString(buffer, 2));
        }
        findCoordinatorRequest.setTopics(topics);
        findCoordinatorRequest.setApp(Serializer.readString(buffer, 2));
        return findCoordinatorRequest;
    }

    @Override
    public void encode(FindCoordinatorRequest payload, ByteBuf buffer) throws Exception {
        buffer.writeShort(payload.getTopics().size());
        for (String topic : payload.getTopics()) {
            Serializer.write(topic, buffer, 2);
        }
        Serializer.write(payload.getApp(), buffer, 2);
    }

    @Override
    public int type() {
        return JoyQueueCommandType.FIND_COORDINATOR_REQUEST.getCode();
    }
}

