/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.FindCoordinatorAckData;
import org.joyqueue.network.command.FindCoordinatorResponse;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.domain.BrokerNode;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;

public class FindCoordinatorResponseCodec
implements PayloadCodec<JoyQueueHeader, FindCoordinatorResponse>,
Type {
    private static final int NONE_BROKER_ID = -1;

    public FindCoordinatorResponse decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        FindCoordinatorResponse findCoordinatorResponse = new FindCoordinatorResponse();
        HashMap coordinators = Maps.newHashMap();
        int topicSize = buffer.readShort();
        for (int i = 0; i < topicSize; ++i) {
            String topic = Serializer.readString(buffer, 2);
            BrokerNode node = null;
            int brokerId = buffer.readInt();
            if (brokerId != -1) {
                node = new BrokerNode();
                node.setId(brokerId);
                node.setHost(Serializer.readString(buffer, 2));
                node.setPort(buffer.readInt());
                node.setDataCenter(Serializer.readString(buffer, 2));
                node.setNearby(buffer.readBoolean());
                node.setWeight(buffer.readInt());
            }
            JoyQueueCode code = JoyQueueCode.valueOf((int)buffer.readInt());
            FindCoordinatorAckData findCoordinatorAckData = new FindCoordinatorAckData(node, code);
            coordinators.put(topic, findCoordinatorAckData);
        }
        findCoordinatorResponse.setCoordinators(coordinators);
        return findCoordinatorResponse;
    }

    @Override
    public void encode(FindCoordinatorResponse payload, ByteBuf buffer) throws Exception {
        buffer.writeShort(payload.getCoordinators().size());
        for (Map.Entry<String, FindCoordinatorAckData> entry : payload.getCoordinators().entrySet()) {
            String topic = entry.getKey();
            FindCoordinatorAckData findCoordinatorAckData = entry.getValue();
            BrokerNode node = findCoordinatorAckData.getNode();
            Serializer.write(topic, buffer, 2);
            if (node == null) {
                buffer.writeInt(-1);
            } else {
                buffer.writeInt(node.getId());
                Serializer.write(node.getHost(), buffer, 2);
                buffer.writeInt(node.getPort());
                Serializer.write(node.getDataCenter(), buffer, 2);
                buffer.writeBoolean(node.isNearby());
                buffer.writeInt(node.getWeight());
            }
            buffer.writeInt(findCoordinatorAckData.getCode().getCode());
        }
    }

    @Override
    public int type() {
        return JoyQueueCommandType.FIND_COORDINATOR_RESPONSE.getCode();
    }
}

