/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import org.joyqueue.network.command.GetTopicsAck;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;

public class GetTopicsAckCodec
implements PayloadCodec<Header, GetTopicsAck>,
Type {
    @Override
    public Object decode(Header header, ByteBuf buffer) throws Exception {
        HashSet<String> topics = new HashSet<String>();
        int topicSize = buffer.readInt();
        for (int i = 0; i < topicSize; ++i) {
            topics.add(Serializer.readString(buffer));
        }
        return new GetTopicsAck().topics(topics);
    }

    @Override
    public void encode(GetTopicsAck payload, ByteBuf buffer) throws Exception {
        buffer.writeInt(payload.getTopics().size());
        for (String topic : payload.getTopics()) {
            Serializer.write(topic, buffer);
        }
    }

    @Override
    public int type() {
        return -41;
    }
}

