/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.joyqueue.domain.QosLevel;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.command.ProduceMessageData;
import org.joyqueue.network.command.ProduceMessageRequest;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;

public class ProduceMessageRequestCodec
implements PayloadCodec<JoyQueueHeader, ProduceMessageRequest>,
Type {
    public ProduceMessageRequest decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        int dataSize = buffer.readShort();
        HashMap data = Maps.newHashMapWithExpectedSize((int)dataSize);
        for (int i = 0; i < dataSize; ++i) {
            String topic = Serializer.readString(buffer, 2);
            String txId = Serializer.readString(buffer, 2);
            int timeout = buffer.readInt();
            QosLevel qosLevel = QosLevel.valueOf((int)buffer.readByte());
            ProduceMessageData produceMessageData = new ProduceMessageData();
            produceMessageData.setTxId(txId);
            produceMessageData.setTimeout(timeout);
            produceMessageData.setQosLevel(qosLevel);
            int messageSize = buffer.readShort();
            ArrayList messages = Lists.newArrayListWithCapacity((int)messageSize);
            for (int j = 0; j < messageSize; ++j) {
                BrokerMessage brokerMessage = Serializer.readBrokerMessage(buffer);
                brokerMessage.setTopic(topic);
                brokerMessage.setTxId(txId);
                messages.add(brokerMessage);
            }
            produceMessageData.setMessages(messages);
            data.put(topic, produceMessageData);
        }
        ProduceMessageRequest produceMessageRequest = new ProduceMessageRequest();
        produceMessageRequest.setApp(Serializer.readString(buffer, 2));
        produceMessageRequest.setData(data);
        return produceMessageRequest;
    }

    @Override
    public void encode(ProduceMessageRequest payload, ByteBuf buffer) throws Exception {
        buffer.writeShort(payload.getData().size());
        for (Map.Entry<String, ProduceMessageData> entry : payload.getData().entrySet()) {
            ProduceMessageData data = entry.getValue();
            Serializer.write(entry.getKey(), buffer, 2);
            Serializer.write(data.getTxId(), buffer, 2);
            buffer.writeInt(data.getTimeout());
            buffer.writeByte(data.getQosLevel().value());
            buffer.writeShort(data.getMessages().size());
            for (BrokerMessage message : data.getMessages()) {
                Serializer.writeBrokerMessage(message, buffer);
            }
        }
        Serializer.write(payload.getApp(), buffer, 2);
    }

    @Override
    public int type() {
        return JoyQueueCommandType.PRODUCE_MESSAGE_REQUEST.getCode();
    }
}

