/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.command.ProduceMessageAckData;
import org.joyqueue.network.command.ProduceMessageAckItemData;
import org.joyqueue.network.command.ProduceMessageResponse;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;

public class ProduceMessageResponseCodec
implements PayloadCodec<JoyQueueHeader, ProduceMessageResponse>,
Type {
    public ProduceMessageResponse decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        int dataSize = buffer.readShort();
        HashMap data = Maps.newHashMap();
        for (int i = 0; i < dataSize; ++i) {
            String topic = Serializer.readString(buffer, 2);
            JoyQueueCode code = JoyQueueCode.valueOf((int)buffer.readInt());
            int itemSize = buffer.readShort();
            ArrayList item = Lists.newArrayListWithCapacity((int)itemSize);
            for (int j = 0; j < itemSize; ++j) {
                short partition = buffer.readShort();
                long index = buffer.readLong();
                long startTime = buffer.readLong();
                item.add(new ProduceMessageAckItemData(partition, index, startTime));
            }
            data.put(topic, new ProduceMessageAckData(item, code));
        }
        ProduceMessageResponse produceMessageResponse = new ProduceMessageResponse();
        produceMessageResponse.setData(data);
        return produceMessageResponse;
    }

    @Override
    public void encode(ProduceMessageResponse payload, ByteBuf buffer) throws Exception {
        buffer.writeShort(payload.getData().size());
        for (Map.Entry<String, ProduceMessageAckData> entry : payload.getData().entrySet()) {
            Serializer.write(entry.getKey(), buffer, 2);
            buffer.writeInt(entry.getValue().getCode().getCode());
            buffer.writeShort(entry.getValue().getItem().size());
            for (ProduceMessageAckItemData data : entry.getValue().getItem()) {
                buffer.writeShort((int)data.getPartition());
                buffer.writeLong(data.getIndex());
                buffer.writeLong(data.getStartTime());
            }
        }
    }

    @Override
    public int type() {
        return JoyQueueCommandType.PRODUCE_MESSAGE_RESPONSE.getCode();
    }
}

