/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.command.RemoveProducerRequest;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;

public class RemoveProducerRequestCodec
implements PayloadCodec<JoyQueueHeader, RemoveProducerRequest>,
Type {
    public RemoveProducerRequest decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        RemoveProducerRequest removeProducerRequest = new RemoveProducerRequest();
        int topicSize = buffer.readShort();
        ArrayList topics = Lists.newArrayListWithCapacity((int)topicSize);
        for (int i = 0; i < topicSize; ++i) {
            topics.add(Serializer.readString(buffer, 2));
        }
        removeProducerRequest.setTopics(topics);
        removeProducerRequest.setApp(Serializer.readString(buffer, 2));
        return removeProducerRequest;
    }

    @Override
    public void encode(RemoveProducerRequest payload, ByteBuf buffer) throws Exception {
        buffer.writeShort(payload.getTopics().size());
        for (String topic : payload.getTopics()) {
            Serializer.write(topic, buffer, 2);
        }
        Serializer.write(payload.getApp(), buffer, 2);
    }

    @Override
    public int type() {
        return JoyQueueCommandType.REMOVE_PRODUCER_REQUEST.getCode();
    }
}

