/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.joyqueue.domain.Subscription;
import org.joyqueue.domain.TopicName;
import org.joyqueue.network.command.UnSubscribe;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;

public class UnSubscribeCodec
implements PayloadCodec<Header, UnSubscribe>,
Type {
    @Override
    public Object decode(Header header, ByteBuf buffer) throws Exception {
        Short subscriptionSize = buffer.readShort();
        ArrayList<Subscription> subscriptions = new ArrayList<Subscription>();
        if (subscriptionSize > 0) {
            for (int i = 0; i < subscriptionSize; ++i) {
                TopicName topic = TopicName.parse((String)Serializer.readString(buffer));
                String app = Serializer.readString(buffer);
                Subscription.Type type = Subscription.Type.valueOf((byte)buffer.readByte());
                subscriptions.add(new Subscription(topic, app, type));
            }
        }
        return new UnSubscribe().subscriptions(subscriptions);
    }

    @Override
    public void encode(UnSubscribe payload, ByteBuf buffer) throws Exception {
        List<Subscription> subscriptions = payload.getSubscriptions();
        int subscriptionSize = subscriptions == null ? 0 : subscriptions.size();
        buffer.writeShort(subscriptionSize);
        if (subscriptionSize > 0) {
            for (Subscription subscription : subscriptions) {
                Serializer.write(subscription.getTopic().getFullName(), buffer);
                Serializer.write(subscription.getApp(), buffer);
                buffer.writeByte((int)subscription.getType().getValue());
            }
        }
    }

    @Override
    public int type() {
        return 40;
    }
}

