/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.command;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.joyqueue.network.session.Language;
import org.joyqueue.network.transport.command.JoyQueuePayload;

public class Authorization
extends JoyQueuePayload {
    private String app;
    private String token;
    private String clientVersion;
    private Language language = Language.JAVA;

    public String getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public Authorization token(String token) {
        this.setToken(token);
        return this;
    }

    public Authorization app(String app) {
        this.setApp(app);
        return this;
    }

    public Authorization clientVersion(String version) {
        this.setClientVersion(version);
        return this;
    }

    public Authorization language(Language language) {
        this.setLanguage(language);
        return this;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((this.token != null && !this.token.isEmpty() ? 1 : 0) != 0, (Object)" token can not be null");
        Preconditions.checkArgument((this.app != null && !this.app.isEmpty() ? 1 : 0) != 0, (Object)" app can not be null");
        Preconditions.checkArgument((this.clientVersion != null && !this.clientVersion.isEmpty() ? 1 : 0) != 0, (Object)" clientVersion can not be null");
        Preconditions.checkArgument((this.language != null ? 1 : 0) != 0, (Object)" clientVersion can not be null");
    }

    @Override
    public int type() {
        return 63;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Authorization{");
        sb.append("app='").append(this.app).append('\'');
        sb.append(", token='").append(this.token).append('\'');
        sb.append(", clientVersion='").append(this.clientVersion).append('\'');
        sb.append(", language=").append((Object)this.language);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Authorization that = (Authorization)o;
        return Objects.equal((Object)this.app, (Object)that.app) && Objects.equal((Object)this.token, (Object)that.token) && Objects.equal((Object)this.clientVersion, (Object)that.clientVersion) && this.language == that.language;
    }

    public int hashCode() {
        int result = this.app != null ? this.app.hashCode() : 0;
        result = 31 * result + (this.token != null ? this.token.hashCode() : 0);
        result = 31 * result + (this.clientVersion != null ? this.clientVersion.hashCode() : 0);
        result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
        return result;
    }
}

