/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.event;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.joyqueue.network.event.TransportEvent;
import org.joyqueue.network.event.TransportEventType;
import org.joyqueue.network.transport.RequestBarrier;
import org.joyqueue.network.transport.TransportHelper;
import org.joyqueue.toolkit.concurrent.EventBus;

@ChannelHandler.Sharable
public class TransportEventHandler
extends ChannelInboundHandlerAdapter {
    private RequestBarrier requestBarrier;
    private EventBus<TransportEvent> eventBus;

    public TransportEventHandler(RequestBarrier requestBarrier, EventBus<TransportEvent> eventBus) {
        this.requestBarrier = requestBarrier;
        this.eventBus = eventBus;
        try {
            this.eventBus.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.eventBus.inform((Object)new TransportEvent(TransportEventType.CONNECT, TransportHelper.getOrNewTransport(ctx.channel(), this.requestBarrier)));
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.eventBus.inform((Object)new TransportEvent(TransportEventType.CLOSE, TransportHelper.getOrNewTransport(ctx.channel(), this.requestBarrier)));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        this.eventBus.inform((Object)new TransportEvent(TransportEventType.EXCEPTION, TransportHelper.getOrNewTransport(ctx.channel(), this.requestBarrier)));
    }
}

