/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.joyqueue.network.transport.exception.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ClientConnectionHandler
extends ChannelInboundHandlerAdapter {
    protected static final Logger logger = LoggerFactory.getLogger(ClientConnectionHandler.class);

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Channel channel = ctx.channel();
        try {
            channel.close().await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (cause.getMessage().contains("Connection reset by peer")) {
            logger.error("channel close, address: {}, connection reset by peer", (Object)channel.remoteAddress());
            return;
        }
        if (TransportException.isClosed(cause)) {
            logger.error("channel is closed, address: {}", (Object)channel.remoteAddress());
        } else {
            logger.error("channel exception, address: {}", (Object)channel.remoteAddress(), (Object)cause);
        }
    }
}

