/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.serializer;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.network.serializer.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchMessageSerializer {
    private static final Logger logger = LoggerFactory.getLogger(BatchMessageSerializer.class);
    private static final int FIX_LENGTH = 14;

    public static int sizeOf(BrokerMessage message) {
        int bodyLength = 14;
        ByteBuffer buffer = message.getBody();
        int length = buffer == null ? 0 : buffer.remaining();
        bodyLength += length;
        byte[] bytes = Serializer.getBytes((String)message.getBusinessId(), (Charset)Charsets.UTF_8);
        bodyLength += bytes == null ? 0 : bytes.length;
        bytes = Serializer.getBytes((String)Serializer.toProperties((Map)message.getAttributes()), (Charset)Charsets.UTF_8);
        return bodyLength += bytes == null ? 0 : bytes.length;
    }

    public static byte[] serialize(List<BrokerMessage> messages) {
        int totalSize = 0;
        for (BrokerMessage message : messages) {
            totalSize += BatchMessageSerializer.sizeOf(message);
        }
        ByteBuffer buffer = ByteBuffer.allocate(totalSize);
        for (BrokerMessage message : messages) {
            int startPosition = buffer.position();
            buffer.putInt(0);
            buffer.put(message.getPriority());
            buffer.putShort(message.getFlag());
            Serializer.write(message.getByteBody(), buffer, 4);
            Serializer.write(message.getBusinessId(), buffer, 1);
            Serializer.write(Serializer.toProperties((Map)message.getAttributes()), buffer, 2);
            buffer.putInt(startPosition, buffer.position() - startPosition);
        }
        return buffer.array();
    }

    public static List<BrokerMessage> deserialize(BrokerMessage brokerMessage) {
        ArrayList result = Lists.newArrayListWithCapacity((int)brokerMessage.getFlag());
        ByteBuffer bodyBuffer = ByteBuffer.wrap(brokerMessage.getByteBody());
        for (int i = 0; i < brokerMessage.getFlag(); ++i) {
            int size = bodyBuffer.getInt();
            byte priority = bodyBuffer.get();
            short flag = bodyBuffer.getShort();
            byte[] body = new byte[bodyBuffer.getInt()];
            bodyBuffer.get(body);
            byte[] businessId = new byte[bodyBuffer.get()];
            bodyBuffer.get(businessId);
            byte[] attributes = new byte[bodyBuffer.getShort()];
            bodyBuffer.get(attributes);
            BrokerMessage message = new BrokerMessage();
            message.setTopic(brokerMessage.getTopic());
            message.setApp(brokerMessage.getApp());
            message.setPartition(brokerMessage.getPartition());
            message.setStartTime(brokerMessage.getStartTime());
            message.setSource(brokerMessage.getSource());
            message.setClientIp(brokerMessage.getClientIp());
            message.setCompressed(false);
            message.setBatch(brokerMessage.isBatch());
            message.setMsgIndexNo(brokerMessage.getMsgIndexNo() + (long)i);
            message.setBody(body);
            message.setBusinessId(ArrayUtils.isEmpty((byte[])businessId) ? null : new String(businessId, Charsets.UTF_8));
            message.setPriority(priority);
            message.setFlag(flag);
            message.setSize(size);
            try {
                message.setAttributes(ArrayUtils.isEmpty((byte[])attributes) ? null : Serializer.toStringMap((String)new String(attributes, Charsets.UTF_8)));
            }
            catch (IOException e) {
                logger.debug("", (Throwable)e);
            }
            result.add(message);
        }
        return result;
    }
}

