/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.serializer;

import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class JoyQueueMapTools {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final byte BYTE_TYPE = 1;
    public static final byte SHORT_TYPE = 2;
    public static final byte INT_TYPE = 4;
    public static final byte LONG_TYPE = 8;
    public static final byte DOUBLE_TYPE = 7;
    public static final byte STRING_BYTE_TYPE = 9;
    public static final byte STRING_SHORT_TYPE = 10;
    public static final byte STRING_INT_TYPE = 11;
    public static final byte BYTE_ARRAY_INT_TYPE = 12;

    public static Map<Object, Object> readMap(ByteBuf in) throws Exception {
        int size = in.readInt();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        if (0 == size) {
            return hashMap;
        }
        for (int i = 0; i < size; ++i) {
            byte type = in.readByte();
            Object key = JoyQueueMapTools.readObject(type, in);
            type = in.readByte();
            Object value = JoyQueueMapTools.readObject(type, in);
            if (key == null || value == null) continue;
            hashMap.put(key, value);
        }
        return hashMap;
    }

    public static Object readObject(byte type, ByteBuf in) {
        Object value = null;
        switch (type) {
            case 1: {
                value = in.readByte();
                break;
            }
            case 2: {
                value = in.readShort();
                break;
            }
            case 4: {
                value = in.readInt();
                break;
            }
            case 8: {
                value = in.readLong();
                break;
            }
            case 7: {
                value = in.readDouble();
                break;
            }
            case 9: {
                value = JoyQueueMapTools.readByteString(in);
                break;
            }
            case 10: {
                value = JoyQueueMapTools.readShortString(in);
                break;
            }
            case 11: {
                value = JoyQueueMapTools.readIntString(in);
                break;
            }
            default: {
                throw new RuntimeException("type is invalid:" + type);
            }
        }
        Object mRetObject = value;
        return mRetObject;
    }

    private static String readByteString(ByteBuf in) {
        byte len = in.readByte();
        return JoyQueueMapTools.readString(in, len);
    }

    private static String readShortString(ByteBuf in) {
        short len = in.readShort();
        return JoyQueueMapTools.readString(in, len);
    }

    private static String readIntString(ByteBuf in) {
        int len = in.readInt();
        return JoyQueueMapTools.readString(in, len);
    }

    private static String readString(ByteBuf in, int len) {
        if (len == 0) {
            return "";
        }
        byte[] bytes = new byte[len];
        in.readBytes(bytes);
        return new String(bytes, UTF8);
    }

    public static <K, V> void write(Map<K, V> hashMap, ByteBuf out) throws Exception {
        int size = hashMap.size();
        out.writeInt(size);
        if (0 == size) {
            return;
        }
        for (Map.Entry<K, V> entry : hashMap.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            if (key != null && value != null) {
                JoyQueueMapTools.write(key, out);
                JoyQueueMapTools.write(value, out);
                continue;
            }
            if (value != null) continue;
            throw new RuntimeException("map value can't be null for serializing,key:" + key);
        }
    }

    public static void write(Object object, ByteBuf out) {
        if (object instanceof Byte) {
            out.writeByte(1);
            out.writeByte((int)((Byte)object).byteValue());
        } else if (object instanceof Short) {
            out.writeByte(2);
            out.writeShort((int)((Short)object).shortValue());
        } else if (object instanceof Integer) {
            out.writeByte(4);
            out.writeInt(((Integer)object).intValue());
        } else if (object instanceof Long) {
            out.writeByte(8);
            out.writeLong(((Long)object).longValue());
        } else if (object instanceof Double) {
            out.writeByte(7);
            out.writeDouble(((Double)object).doubleValue());
        } else if (object instanceof String) {
            String str = (String)object;
            byte[] bytes = str.getBytes(UTF8);
            int size = bytes.length;
            if (size <= 127) {
                out.writeByte(9);
                out.writeByte((int)((byte)size));
            } else if (size <= Short.MAX_VALUE) {
                out.writeByte(10);
                out.writeShort((int)((short)size));
            } else if (size <= Integer.MAX_VALUE) {
                out.writeByte(11);
                out.writeInt(size);
            }
            out.writeBytes(bytes);
        } else {
            throw new RuntimeException("type is illegal:" + object);
        }
    }

    public static Byte getByte(Map<Object, Object> map, Object key) {
        Object obj = map.get(key);
        if (obj == null) {
            return (byte)0;
        }
        return (Byte)obj;
    }

    public static Short getShort(Map<Object, Object> map, Object key) {
        Object obj = map.get(key);
        if (obj == null) {
            return (short)0;
        }
        return (Short)obj;
    }

    public static Integer getInt(Map<Object, Object> map, Object key) {
        Object obj = map.get(key);
        if (obj == null) {
            return 0;
        }
        return (Integer)obj;
    }

    public static Long getLong(Map<Object, Object> map, Object key) {
        Object obj = map.get(key);
        if (obj == null) {
            return 0L;
        }
        return (Long)obj;
    }

    public static String getString(Map<Object, Object> map, Object key) {
        Object obj = map.get(key);
        if (obj == null) {
            return null;
        }
        return (String)obj;
    }
}

