/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.serializer;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.joyqueue.domain.AppToken;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.ClientType;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Producer;
import org.joyqueue.domain.Subscription;
import org.joyqueue.domain.Topic;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.domain.TopicType;
import org.joyqueue.message.BrokerMessage;
import org.joyqueue.message.BrokerPrepare;
import org.joyqueue.message.BrokerRollback;
import org.joyqueue.message.Message;
import org.joyqueue.network.serializer.JoyQueueMapTools;
import org.joyqueue.toolkit.io.Compressor;
import org.joyqueue.toolkit.io.Compressors;
import org.joyqueue.toolkit.io.Zip;
import org.joyqueue.toolkit.io.ZipUtil;
import org.joyqueue.toolkit.retry.RetryPolicy;
import org.joyqueue.toolkit.serialize.AbstractSerializer;

public class Serializer
extends AbstractSerializer {
    public static final byte BYTE_SIZE = 1;
    public static final byte SHORT_SIZE = 2;
    public static final byte INT_SIZE = 4;
    private static final int fixBodyLength = 73;
    private static final byte MESSAGE_VERSION_V0 = 0;
    private static final byte MESSAGE_VERSION_V1 = 1;
    private static final byte CURRENT_MESSAGE_VERSION = 1;

    public static void writeBrokerMessage(BrokerMessage message, ByteBuf out) throws Exception {
        int size = Serializer.sizeOf(message);
        Serializer.writeBrokerMessage(message, out, size);
    }

    public static void writeBrokerMessage(BrokerMessage[] messages, ByteBuf out) throws Exception {
        if (out == null) {
            return;
        }
        int count = messages == null ? 0 : messages.length;
        out.writeShort(count);
        for (int i = 0; i < count; ++i) {
            Serializer.writeBrokerMessage(messages[i], out);
        }
    }

    public static int sizeOf(BrokerMessage message) {
        int bodyLength = 73;
        ByteBuffer buffer = message.getBody();
        int length = buffer == null ? 0 : buffer.remaining();
        bodyLength += length;
        byte[] bytes = Serializer.getBytes((String)message.getApp(), (Charset)Charsets.UTF_8);
        bodyLength += bytes == null ? 0 : bytes.length;
        bytes = Serializer.getBytes((String)message.getBusinessId(), (Charset)Charsets.UTF_8);
        bodyLength += bytes == null ? 0 : bytes.length;
        bytes = Serializer.getBytes((String)Serializer.toProperties((Map)message.getAttributes()), (Charset)Charsets.UTF_8);
        bodyLength += bytes == null ? 0 : bytes.length;
        bytes = message.getExtension();
        return bodyLength += bytes == null ? 0 : bytes.length;
    }

    public static void writeBrokerMessage(BrokerMessage message, ByteBuf out, int size) throws Exception {
        int begin = out.writerIndex();
        out.writeInt(size);
        out.writeShort((int)message.getPartition());
        out.writeLong(message.getMsgIndexNo());
        out.writeInt(message.getTerm());
        out.writeShort(4660);
        short sysCode = (byte)(message.isCompressed() ? 1 : 0);
        sysCode = (short)(sysCode | (message.isOrdered() ? 1 : 0) << 1 & 3);
        sysCode = (short)(sysCode | message.getSource() << 2 & 0xC);
        if (message.isCompressed()) {
            sysCode = (short)(sysCode | message.getCompressionType().getType() << 4 & 0x70);
        }
        if (message.getClientIp().length < 7) {
            sysCode = (short)(sysCode | 0x80);
        }
        sysCode = (short)(sysCode | 0x100);
        sysCode = (short)(sysCode | (message.isBatch() ? 1 : 0) << 12);
        out.writeShort((int)sysCode);
        out.writeByte((int)message.getPriority());
        byte[] clientIp = new byte[16];
        if (message.getClientIp() != null) {
            System.arraycopy(message.getClientIp(), 0, clientIp, 0, Math.min(message.getClientIp().length, clientIp.length));
        }
        out.writeBytes(clientIp);
        out.writeLong(message.getStartTime());
        out.writeInt(0);
        out.writeLong(message.getBodyCRC());
        out.writeShort((int)message.getFlag());
        if (message.getByteBody() != null) {
            Serializer.write(message.getBody(), out, true);
        } else {
            out.writeInt(0);
        }
        Serializer.write(message.getBusinessId(), out);
        Serializer.write(Serializer.toProperties((Map)message.getAttributes()), out, 2);
        Serializer.write(message.getExtension(), out, true);
        Serializer.write(message.getApp(), out);
        message.setSize(size);
    }

    public static void write(byte[] value, ByteBuf out, boolean writeLength) {
        int length;
        int n = length = value == null ? 0 : value.length;
        if (writeLength) {
            out.writeInt(length);
        }
        if (length > 0) {
            out.writeBytes(value);
        }
    }

    public static void write(byte[] value, ByteBuffer out, int lengthSize) {
        Serializer.write(value, out, true, lengthSize);
    }

    public static void write(byte[] value, ByteBuffer out, boolean writeLength, int lengthSize) {
        int length;
        int n = length = value == null ? 0 : value.length;
        if (writeLength) {
            if (lengthSize == 1) {
                out.put((byte)length);
            } else if (lengthSize == 2) {
                out.putShort((short)length);
            } else {
                out.putInt(length);
            }
        }
        if (length > 0) {
            out.put(value);
        }
    }

    public static BrokerMessage readBrokerMessage(ByteBuf in) throws Exception {
        BrokerMessage message = new BrokerMessage();
        int totalLength = in.readInt();
        message.setPartition(in.readShort());
        message.setMsgIndexNo(in.readLong());
        message.setTerm(in.readInt());
        in.readShort();
        short sysCode = in.readShort();
        byte version = (byte)(sysCode >> 8 & 0xF);
        boolean isIpv4 = (sysCode & 0x80) > 1;
        message.setCompressed((sysCode & 1) > 0);
        message.setOrdered((sysCode & 2) > 0);
        message.setSource((byte)(sysCode >> 2 & 3));
        message.setBatch(sysCode >> 12 == 1);
        if (version == 0) {
            message.setCompressionType(Message.CompressionType.valueOf((int)(sysCode >> 4 & 3)));
            isIpv4 = true;
        } else {
            message.setCompressionType(Message.CompressionType.valueOf((int)(sysCode >> 4 & 7)));
        }
        message.setPriority(in.readByte());
        if (isIpv4) {
            message.setClientIp(Serializer.readBytes(in, 6));
            Serializer.readBytes(in, 10);
        } else {
            message.setClientIp(Serializer.readBytes(in, 16));
        }
        message.setStartTime(in.readLong());
        message.setStoreTime(in.readInt());
        message.setBodyCRC(in.readLong());
        message.setFlag(in.readShort());
        int bodyLength = in.readInt();
        message.setBody(Serializer.readBytes(in, bodyLength));
        message.setBusinessId(Serializer.readString(in));
        message.setAttributes(Serializer.toStringMap((String)Serializer.readString(in, 2)));
        int extensionLength = in.readInt();
        message.setExtension(Serializer.readBytes(in, extensionLength));
        message.setApp(Serializer.readString(in));
        return message;
    }

    public static ByteBuf write(BrokerPrepare prepare, ByteBuf out) throws Exception {
        int begin = out.writerIndex();
        out.writeInt(0);
        out.writeShort(13398);
        out.writeByte((int)prepare.getType());
        out.writeLong(prepare.getStartTime());
        out.writeLong((long)prepare.getStoreTime());
        Serializer.write(prepare.getTopic(), out);
        Serializer.write(prepare.getTxId(), out, 2);
        Serializer.write(prepare.getQueryId(), out, 2);
        Serializer.write(prepare.getAttrs(), out);
        int end = out.writerIndex();
        int size = end - begin;
        prepare.setSize(size);
        out.writerIndex(begin);
        out.writeInt(size);
        out.writerIndex(end);
        return out;
    }

    public static ByteBuf write(BrokerRollback rollback, ByteBuf out) throws Exception {
        int begin = out.writerIndex();
        out.writeInt(0);
        out.writeShort(13398);
        out.writeByte((int)rollback.getType());
        out.writeLong(rollback.getStartTime());
        out.writeLong((long)rollback.getStoreTime());
        Serializer.write(rollback.getTopic(), out);
        Serializer.write(rollback.getTxId(), out, 2);
        Serializer.write(rollback.getAttrs(), out);
        int end = out.writerIndex();
        int size = end - begin;
        rollback.setSize(size);
        out.writerIndex(begin);
        out.writeInt(size);
        out.writerIndex(end);
        return out;
    }

    public static void write(TopicConfig topicConfig, ByteBuf out, int version) throws Exception {
        Serializer.write(topicConfig.getName().getFullName(), out);
        out.writeShort((int)topicConfig.getPartitions());
        out.writeByte((int)topicConfig.getType().code());
        Set priorityPartitions = topicConfig.getPriorityPartitions();
        if (null == priorityPartitions) {
            out.writeInt(0);
        } else {
            out.writeInt(priorityPartitions.size());
            for (Short partition : priorityPartitions) {
                out.writeShort((int)partition.shortValue());
            }
        }
        if (null == topicConfig.getPartitionGroups()) {
            out.writeInt(0);
        } else {
            out.writeInt(topicConfig.getPartitionGroups().size());
            for (PartitionGroup group : topicConfig.getPartitionGroups().values()) {
                Serializer.write(group, out, version);
            }
        }
    }

    public static TopicConfig readTopicConfig(ByteBuf in, int version) throws Exception {
        TopicConfig topicConfig = new TopicConfig();
        topicConfig.setName(TopicName.parse((String)Serializer.readString(in)));
        topicConfig.setPartitions(in.readShort());
        topicConfig.setType(Topic.Type.valueOf((byte)in.readByte()));
        int priorityPartitionSize = in.readInt();
        TreeSet<Short> priorityPartitions = new TreeSet<Short>();
        for (int i = 0; i < priorityPartitionSize; ++i) {
            priorityPartitions.add(in.readShort());
        }
        int partitionGroupSize = in.readInt();
        HashMap<Integer, PartitionGroup> partitionGroups = new HashMap<Integer, PartitionGroup>(partitionGroupSize);
        for (int i = 0; i < partitionGroupSize; ++i) {
            PartitionGroup group = Serializer.readPartitionGroup(in, version);
            partitionGroups.put(group.getGroup(), group);
        }
        topicConfig.setPartitionGroups(partitionGroups);
        return topicConfig;
    }

    public static void write(Topic topic, ByteBuf out) throws Exception {
        Serializer.write(topic.getName().getFullName(), out);
        out.writeShort((int)topic.getPartitions());
        out.writeByte((int)topic.getType().code());
        Set priorityPartitions = topic.getPriorityPartitions();
        if (null == priorityPartitions) {
            out.writeInt(0);
        } else {
            out.writeInt(priorityPartitions.size());
            for (Short partition : priorityPartitions) {
                out.writeShort((int)partition.shortValue());
            }
        }
    }

    public static Topic readTopic(ByteBuf in) throws Exception {
        Topic topic = new Topic();
        topic.setName(TopicName.parse((String)Serializer.readString(in)));
        topic.setPartitions(in.readShort());
        topic.setType(Topic.Type.valueOf((byte)in.readByte()));
        int priorityPartitionSize = in.readInt();
        TreeSet<Short> priorityPartitions = new TreeSet<Short>();
        for (int i = 0; i < priorityPartitionSize; ++i) {
            priorityPartitions.add(in.readShort());
        }
        return topic;
    }

    public static void write(AppToken appToken, ByteBuf out) throws Exception {
        out.writeLong(appToken.getId().longValue());
        Serializer.write(appToken.getApp(), out);
        Serializer.write(appToken.getToken(), out);
        out.writeLong(appToken.getEffectiveTime().getTime());
        out.writeLong(appToken.getExpirationTime().getTime());
    }

    public static AppToken readAppToken(ByteBuf in) throws Exception {
        AppToken appToken = new AppToken();
        appToken.setId(Long.valueOf(in.readLong()));
        appToken.setApp(Serializer.readString(in));
        appToken.setToken(Serializer.readString(in));
        appToken.setEffectiveTime(new Date(in.readLong()));
        appToken.setExpirationTime(new Date(in.readLong()));
        return appToken;
    }

    public static void write(PartitionGroup partitionGroup, ByteBuf out, int version) throws Exception {
        Serializer.write(partitionGroup.getTopic().getFullName(), out);
        out.writeInt(partitionGroup.getLeader().intValue());
        if (null == partitionGroup.getIsrs()) {
            out.writeInt(0);
        } else {
            out.writeInt(partitionGroup.getIsrs().size());
            for (Integer isr : partitionGroup.getIsrs()) {
                out.writeInt(isr.intValue());
            }
        }
        if (null == partitionGroup.getLearners()) {
            out.writeInt(0);
        } else {
            out.writeInt(partitionGroup.getLearners().size());
            for (Integer learner : partitionGroup.getLearners()) {
                out.writeInt(learner.intValue());
            }
        }
        out.writeInt(partitionGroup.getTerm().intValue());
        out.writeInt(partitionGroup.getGroup());
        if (null == partitionGroup.getPartitions()) {
            out.writeInt(0);
        } else {
            out.writeInt(partitionGroup.getPartitions().size());
            for (Short partition : partitionGroup.getPartitions()) {
                out.writeShort((int)partition.shortValue());
            }
        }
        if (null == partitionGroup.getReplicas()) {
            out.writeInt(0);
        } else {
            out.writeInt(partitionGroup.getReplicas().size());
            for (Integer replica : partitionGroup.getReplicas()) {
                out.writeInt(replica.intValue());
            }
        }
        out.writeInt(partitionGroup.getElectType().type());
        Map brokers = partitionGroup.getBrokers();
        if (null == brokers) {
            out.writeInt(0);
        } else {
            out.writeInt(brokers.size());
            for (Broker broker : brokers.values()) {
                Serializer.write(broker, out);
            }
        }
        if (version >= 3) {
            out.writeInt(partitionGroup.getRecLeader().intValue());
        }
    }

    public static PartitionGroup readPartitionGroup(ByteBuf in, int version) throws Exception {
        PartitionGroup group = new PartitionGroup();
        group.setTopic(TopicName.parse((String)Serializer.readString(in)));
        group.setLeader(Integer.valueOf(in.readInt()));
        TreeSet<Integer> isrs = new TreeSet<Integer>();
        int istLen = in.readInt();
        for (int i = 0; i < istLen; ++i) {
            isrs.add(in.readInt());
        }
        group.setIsrs(isrs);
        int learnerLen = in.readInt();
        TreeSet<Integer> learners = new TreeSet<Integer>();
        for (int i = 0; i < learnerLen; ++i) {
            learners.add(in.readInt());
        }
        group.setTerm(Integer.valueOf(in.readInt()));
        group.setGroup(in.readInt());
        TreeSet<Short> partitions = new TreeSet<Short>();
        int partitionsLen = in.readInt();
        for (int i = 0; i < partitionsLen; ++i) {
            partitions.add(in.readShort());
        }
        group.setPartitions(partitions);
        TreeSet<Integer> replicaGroups = new TreeSet<Integer>();
        int replicaGroupsLen = in.readInt();
        for (int i = 0; i < replicaGroupsLen; ++i) {
            replicaGroups.add(in.readInt());
        }
        group.setReplicas(replicaGroups);
        group.setElectType(PartitionGroup.ElectType.valueOf((int)in.readInt()));
        int brokerSize = in.readInt();
        HashMap<Integer, Broker> brokers = new HashMap<Integer, Broker>(brokerSize);
        for (int i = 0; i < brokerSize; ++i) {
            Broker broker = Serializer.readBroker(in);
            brokers.put(broker.getId(), broker);
        }
        group.setBrokers(brokers);
        if (version >= 3) {
            group.setRecLeader(Integer.valueOf(in.readInt()));
        }
        return group;
    }

    public static void write(Broker broker, ByteBuf out) throws Exception {
        out.writeInt(broker.getId().intValue());
        Serializer.write(broker.getIp(), out);
        out.writeInt(broker.getPort());
        Serializer.write(broker.getDataCenter(), out);
        Serializer.write(broker.getRetryType(), out);
    }

    public static Broker readBroker(ByteBuf in) throws Exception {
        Broker broker = new Broker();
        broker.setId(in.readInt());
        broker.setIp(Serializer.readString(in));
        broker.setPort(in.readInt());
        broker.setDataCenter(Serializer.readString(in));
        broker.setRetryType(Serializer.readString(in));
        return broker;
    }

    public static void write(int version, Producer producer, ByteBuf out) throws Exception {
        Producer.ProducerLimitPolicy limitPolicy;
        Serializer.write(producer.getApp(), out);
        Serializer.write(producer.getTopic().getFullName(), out);
        out.writeByte((int)producer.getType().getValue());
        out.writeByte((int)producer.getClientType().value());
        Producer.ProducerPolicy policy = producer.getProducerPolicy();
        boolean hasPolicy = null != policy;
        out.writeBoolean(hasPolicy);
        if (hasPolicy) {
            out.writeInt(policy.getTimeOut().intValue());
            out.writeBoolean(policy.getArchive().booleanValue());
            out.writeBoolean(policy.getNearby().booleanValue());
            out.writeBoolean(policy.isSingle().booleanValue());
            Set blackList = policy.getBlackList();
            if (null != blackList && blackList.size() > 0) {
                out.writeBoolean(true);
                String blackListStr = Arrays.toString(blackList.toArray());
                Serializer.write(blackListStr.substring(1, blackListStr.length() - 1), out, 2);
            } else {
                out.writeBoolean(false);
            }
            Map wight = policy.getWeight();
            if (null != wight && wight.size() > 0) {
                out.writeBoolean(true);
                StringBuilder stringBuilder = new StringBuilder();
                for (Map.Entry entry : wight.entrySet()) {
                    stringBuilder.append((String)entry.getKey()).append(":").append(entry.getValue()).append(",");
                }
                Serializer.write(stringBuilder.substring(0, stringBuilder.length() - 1), out);
            } else {
                out.writeBoolean(false);
            }
        }
        if ((limitPolicy = producer.getLimitPolicy()) == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(limitPolicy.getTps().intValue());
            out.writeInt(limitPolicy.getTraffic().intValue());
        }
    }

    public static Producer readProducer(int version, ByteBuf in) throws Exception {
        boolean hasLimitPolicy;
        Producer producer = new Producer();
        producer.setApp(Serializer.readString(in));
        producer.setTopic(TopicName.parse((String)Serializer.readString(in)));
        producer.setType(Subscription.Type.valueOf((byte)in.readByte()));
        producer.setClientType(ClientType.valueOf((int)in.readByte()));
        boolean hasPolicy = in.readBoolean();
        if (hasPolicy) {
            boolean hasWight;
            Producer.ProducerPolicy.Builder policy = Producer.ProducerPolicy.Builder.build();
            policy.timeout(Integer.valueOf(in.readInt())).archive(Boolean.valueOf(in.readBoolean())).nearby(Boolean.valueOf(in.readBoolean())).single(Boolean.valueOf(in.readBoolean()));
            boolean hasBlackList = in.readBoolean();
            if (hasBlackList) {
                policy.blackList(Serializer.readString(in, 2));
            }
            if (hasWight = in.readBoolean()) {
                policy.weight(Serializer.readString(in));
            }
            producer.setProducerPolicy(policy.create());
        }
        if (hasLimitPolicy = in.readBoolean()) {
            Producer.ProducerLimitPolicy limitPolicy = new Producer.ProducerLimitPolicy();
            limitPolicy.setTps(Integer.valueOf(in.readInt()));
            limitPolicy.setTraffic(Integer.valueOf(in.readInt()));
            producer.setLimitPolicy(limitPolicy);
        }
        return producer;
    }

    public static void write(int version, Consumer consumer, ByteBuf out) throws Exception {
        Consumer.ConsumerLimitPolicy limitPolicy;
        Serializer.write(consumer.getApp(), out);
        Serializer.write(consumer.getTopic().getFullName(), out);
        out.writeByte((int)consumer.getType().getValue());
        out.writeByte((int)consumer.getClientType().value());
        if (version >= 3) {
            out.writeByte((int)consumer.getTopicType().code());
        }
        Consumer.ConsumerPolicy consumerPolicy = consumer.getConsumerPolicy();
        RetryPolicy retryPolicy = consumer.getRetryPolicy();
        boolean hasConsumerPolicy = null != consumerPolicy;
        boolean hasRetryPolicy = null != retryPolicy;
        out.writeBoolean(hasConsumerPolicy);
        if (hasConsumerPolicy) {
            out.writeInt(consumerPolicy.getAckTimeout().intValue());
            out.writeShort((int)consumerPolicy.getBatchSize().shortValue());
            out.writeInt(consumerPolicy.getConcurrent().intValue());
            out.writeInt(consumerPolicy.getDelay().intValue());
            out.writeInt(consumerPolicy.getErrTimes().intValue());
            out.writeInt(consumerPolicy.getMaxPartitionNum().intValue());
            out.writeInt(consumerPolicy.getReadRetryProbability().intValue());
            out.writeBoolean(consumerPolicy.getArchive().booleanValue());
            Set blackList = consumerPolicy.getBlackList();
            if (null != blackList && blackList.size() > 0) {
                out.writeBoolean(true);
                String blackListStr = Arrays.toString(blackList.toArray());
                Serializer.write(blackListStr.substring(1, blackListStr.length() - 1), out, 2);
            } else {
                out.writeBoolean(false);
            }
            out.writeBoolean(consumerPolicy.getNearby().booleanValue());
            out.writeBoolean(consumerPolicy.getPaused().booleanValue());
            out.writeBoolean(consumerPolicy.getRetry().booleanValue());
            out.writeBoolean(consumerPolicy.getSeq().booleanValue());
        }
        out.writeBoolean(hasRetryPolicy);
        if (hasRetryPolicy) {
            if (null != retryPolicy.getUseExponentialBackOff()) {
                out.writeBoolean(retryPolicy.getUseExponentialBackOff().booleanValue());
                out.writeDouble(retryPolicy.getBackOffMultiplier().doubleValue());
            } else {
                out.writeBoolean(false);
                out.writeDouble(0.0);
            }
            out.writeInt(retryPolicy.getExpireTime().intValue());
            out.writeInt(retryPolicy.getMaxRetryDelay().intValue());
            out.writeInt(retryPolicy.getMaxRetrys().intValue());
            out.writeInt(retryPolicy.getRetryDelay().intValue());
        }
        if ((limitPolicy = consumer.getLimitPolicy()) == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(limitPolicy.getTps().intValue());
            out.writeInt(limitPolicy.getTraffic().intValue());
        }
    }

    public static Consumer readConsumer(int version, ByteBuf in) throws Exception {
        boolean hasLimitPolicy;
        boolean hasRetryPolicy;
        boolean hasConsumerPolicy;
        Consumer consumer = new Consumer();
        consumer.setApp(Serializer.readString(in));
        consumer.setTopic(TopicName.parse((String)Serializer.readString(in)));
        consumer.setType(Subscription.Type.valueOf((byte)in.readByte()));
        consumer.setClientType(ClientType.valueOf((int)in.readByte()));
        if (version >= 3) {
            consumer.setTopicType(TopicType.valueOf((byte)in.readByte()));
        }
        if (hasConsumerPolicy = in.readBoolean()) {
            Consumer.ConsumerPolicy.Builder consumerPolicy = Consumer.ConsumerPolicy.Builder.build();
            consumerPolicy.ackTimeout(Integer.valueOf(in.readInt())).batchSize(Short.valueOf(in.readShort())).concurrent(Integer.valueOf(in.readInt())).delay(Integer.valueOf(in.readInt())).errTimes(Integer.valueOf(in.readInt())).maxPartitionNum(Integer.valueOf(in.readInt())).retryReadProbability(Integer.valueOf(in.readInt())).archive(Boolean.valueOf(in.readBoolean()));
            boolean hasBlackList = in.readBoolean();
            if (hasBlackList) {
                consumerPolicy.blackList(Serializer.readString(in, 2));
            }
            consumerPolicy.nearby(Boolean.valueOf(in.readBoolean())).paused(Boolean.valueOf(in.readBoolean())).retry(Boolean.valueOf(in.readBoolean())).seq(Boolean.valueOf(in.readBoolean()));
            consumer.setConsumerPolicy(consumerPolicy.create());
        }
        if (hasRetryPolicy = in.readBoolean()) {
            RetryPolicy.Builder retryPolicy = RetryPolicy.Builder.build();
            retryPolicy.useExponentialBackOff(Boolean.valueOf(in.readBoolean())).backOffMultiplier(Double.valueOf(in.readDouble())).expireTime(Integer.valueOf(in.readInt())).maxRetryDelay(Integer.valueOf(in.readInt())).maxRetrys(Integer.valueOf(in.readInt())).retryDelay(Integer.valueOf(in.readInt()));
            consumer.setRetryPolicy(retryPolicy.create());
        }
        if (hasLimitPolicy = in.readBoolean()) {
            Consumer.ConsumerLimitPolicy limitPolicy = new Consumer.ConsumerLimitPolicy();
            limitPolicy.setTps(Integer.valueOf(in.readInt()));
            limitPolicy.setTraffic(Integer.valueOf(in.readInt()));
            consumer.setLimitPolicy(limitPolicy);
        }
        return consumer;
    }

    public static void write(String value, ByteBuf out, int lengthSize) throws Exception {
        Serializer.write(value, out, lengthSize, false);
    }

    public static void write(String value, ByteBuffer out, int lengthSize) {
        Serializer.write(value, out, true, lengthSize);
    }

    public static void write(String value, ByteBuffer out, boolean writeLength, int lengthSize) {
        if (out == null) {
            return;
        }
        if (value != null && !value.isEmpty()) {
            byte[] bytes = Serializer.getBytes((String)value, (Charset)Charsets.UTF_8);
            Serializer.write(bytes, out, writeLength, lengthSize);
        } else {
            Serializer.write((byte[])null, out, writeLength, lengthSize);
        }
    }

    public static void write(String value, ByteBuf out) throws Exception {
        Serializer.write(value, out, 1, false);
    }

    public static void write(String value, ByteBuf out, int lengthSize, boolean compressed) throws Exception {
        if (out == null) {
            return;
        }
        if (value != null && !value.isEmpty()) {
            byte[] bytes = Serializer.getBytes((String)value, (Charset)Charsets.UTF_8);
            if (compressed) {
                bytes = Compressors.compress((byte[])bytes, (int)0, (int)bytes.length, (Compressor)Zip.INSTANCE);
            }
            Serializer.write(bytes.length, out, lengthSize);
            out.writeBytes(bytes);
        } else {
            Serializer.write(0, out, lengthSize);
        }
    }

    public static void write(int value, ByteBuf out, int lengthSize) {
        if (out == null) {
            return;
        }
        switch (lengthSize) {
            case 1: {
                out.writeByte(value);
                break;
            }
            case 2: {
                out.writeShort(value);
                break;
            }
            case 4: {
                out.writeInt(value);
            }
        }
    }

    public static void write(byte[] value, ByteBuf out) {
        ByteBuffer wrap = ByteBuffer.wrap(value);
        Serializer.write(wrap, out, true);
    }

    public static void write(ByteBuffer value, ByteBuf out) {
        Serializer.write(value, out, true);
    }

    public static void write(ByteBuffer value, ByteBuf out, boolean writeLength) {
        int length;
        int n = length = value == null ? 0 : value.remaining();
        if (writeLength) {
            out.writeInt(length);
        }
        if (length > 0) {
            if (value.hasArray()) {
                out.writeBytes(value.array(), value.arrayOffset() + value.position(), value.remaining());
            } else {
                out.writeBytes(value.slice());
            }
        }
    }

    public static <K, V> void write(Map<K, V> hashMap, ByteBuf out) throws Exception {
        JoyQueueMapTools.write(hashMap, out);
    }

    public static String readString(ByteBuffer in) throws Exception {
        return Serializer.readString(in, 1, false);
    }

    public static String readString(ByteBuffer in, int lengthSize) throws Exception {
        return Serializer.readString(in, lengthSize, false);
    }

    public static String readString(ByteBuf in) throws Exception {
        return Serializer.readString(in, 1, false);
    }

    public static String readString(ByteBuf in, int lengthSize, boolean compressed) throws Exception {
        int length = lengthSize == 1 ? in.readByte() : (lengthSize == 2 ? in.readShort() : in.readInt());
        return Serializer.read(in, length, compressed, "UTF-8");
    }

    public static String read(ByteBuf in, int length, boolean compressed, String charset) throws Exception {
        if (length <= 0) {
            return null;
        }
        byte[] bytes = Serializer.readBytes(in, length);
        try {
            if (compressed) {
                bytes = ZipUtil.decompressByZlib((byte[])bytes, (int)0, (int)bytes.length);
            }
            if (charset == null || charset.isEmpty()) {
                charset = "UTF-8";
            }
            return new String(bytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }

    private static byte[] readBytes(ByteBuf in, int length) {
        if (in == null || length <= 0) {
            return new byte[0];
        }
        int len = in.readableBytes();
        if (len == 0) {
            return new byte[0];
        }
        if (length < len) {
            len = length;
        }
        byte[] bytes = new byte[len];
        in.readBytes(bytes);
        return bytes;
    }

    public static String readString(ByteBuf in, int lengthSize) throws Exception {
        return Serializer.readString(in, lengthSize, false);
    }

    public static String readString(ByteBuffer in, int lengthSize, boolean compressed) throws Exception {
        int length;
        if (lengthSize == 1) {
            byte[] bytes = new byte[1];
            in.get(bytes);
            length = bytes[0] & 0xFF;
        } else {
            length = lengthSize == 2 ? in.getShort() : in.getInt();
        }
        return Serializer.read(in, length, compressed, "UTF-8");
    }

    public static String read(ByteBuffer in, int length, boolean compressed, String charset) throws Exception {
        if (length <= 0) {
            return null;
        }
        byte[] bytes = Serializer.readBytes((ByteBuffer)in, (int)length);
        try {
            if (compressed) {
                bytes = Compressors.decompress((byte[])bytes, (int)0, (int)bytes.length, (Compressor)Zip.INSTANCE);
            }
            if (charset == null || charset.isEmpty()) {
                charset = "UTF-8";
            }
            return new String(bytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }
}

