/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.session;

import java.util.StringTokenizer;

public class ClientId {
    private String version;
    private String ip;
    private long time;
    private long sequence;
    private String clientId;

    public ClientId() {
    }

    public ClientId(String clientId) {
        if (clientId == null || clientId.isEmpty()) {
            throw new IllegalArgumentException("clientId can not be empty");
        }
        String[] parts = new String[]{null, null, null, null};
        int index = 0;
        StringTokenizer tokenizer = new StringTokenizer(clientId, "-");
        while (tokenizer.hasMoreTokens()) {
            parts[index++] = tokenizer.nextToken();
            if (index < parts.length) continue;
        }
        if (index < parts.length) {
            throw new IllegalArgumentException("clientId is invalid.");
        }
        this.setup(parts[0], parts[1], Long.parseLong(parts[2]), Long.parseLong(parts[3]));
    }

    public ClientId(String[] parts) {
        if (parts == null || parts.length < 4) {
            throw new IllegalArgumentException("parts is invalid.");
        }
        this.setup(parts[0], parts[1], Long.parseLong(parts[2]), Long.parseLong(parts[3]));
    }

    public ClientId(String version, String ip, long time) {
        this.setup(version, ip, time, 0L);
    }

    public ClientId(String version, String ip, long time, long processId) {
        this.setup(version, ip, time, processId);
    }

    protected void setup(String version, String ip, long time, long processId) {
        if (version == null || version.isEmpty()) {
            throw new IllegalArgumentException("version can not be empty");
        }
        if (ip == null || ip.isEmpty()) {
            throw new IllegalArgumentException("ip can not be empty");
        }
        this.version = version;
        this.ip = ip;
        this.time = time;
        long pid = processId;
        if (pid <= 0L) {
            pid = (long)(Math.random() * 65534.0 + 1.0);
        }
        this.sequence = pid;
        StringBuilder builder = new StringBuilder();
        builder.append(version).append('-').append(ip).append('-').append(time).append('-').append(this.sequence);
        this.clientId = builder.toString();
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getIp() {
        return this.ip;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public long getTime() {
        return this.time;
    }

    public void setSequence(long sequence) {
        this.sequence = sequence;
    }

    public long getSequence() {
        return this.sequence;
    }

    public String getClientId() {
        return this.clientId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientId clientId = (ClientId)o;
        if (this.sequence != clientId.sequence) {
            return false;
        }
        if (this.time != clientId.time) {
            return false;
        }
        return !(this.ip != null ? !this.ip.equals(clientId.ip) : clientId.ip != null);
    }

    public int hashCode() {
        int result = this.ip != null ? this.ip.hashCode() : 0;
        result = 31 * result + (int)(this.time ^ this.time >>> 32);
        result = 31 * result + (int)(this.sequence ^ this.sequence >>> 32);
        return result;
    }

    public String toString() {
        return this.getClientId();
    }
}

