/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.session;

import org.joyqueue.network.session.Joint;

public class Consumer
extends Joint {
    private String id;
    private String connectionId;
    private String selector;
    private Joint joint;
    private volatile long lastGetMessageTime;
    private volatile long rebalanceTime;
    private volatile int maxLockQueues = 1;
    private ConsumeType type = ConsumeType.JOYQUEUE;

    public Consumer() {
    }

    public Consumer(String id, String topic, String app) {
        super(topic, app);
        this.id = id;
    }

    public Consumer(String id, String topic, String app, ConsumeType type) {
        this(id, topic, app);
        this.connectionId = id;
        this.type = type;
    }

    public Consumer(String topic, String app) {
        super(topic, app);
    }

    public Consumer(String id, String connectionId, String topic, String selector) {
        this.id = id;
        this.connectionId = connectionId;
        this.topic = topic;
        this.selector = selector;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public long getLastGetMessageTime() {
        return this.lastGetMessageTime;
    }

    public void setLastGetMessageTime(long lastGetMessageTime) {
        this.lastGetMessageTime = lastGetMessageTime;
    }

    public long getRebalanceTime() {
        return this.rebalanceTime;
    }

    public void setRebalanceTime(long rebalanceTime) {
        this.rebalanceTime = rebalanceTime;
    }

    public int getMaxLockQueues() {
        return this.maxLockQueues;
    }

    public void setMaxLockQueues(int maxLockQueues) {
        this.maxLockQueues = maxLockQueues;
    }

    public ConsumeType getType() {
        return this.type;
    }

    public void setType(ConsumeType type) {
        this.type = type;
    }

    public Joint getJoint() {
        if (this.joint == null) {
            this.joint = new Joint(this.topic, this.app);
        }
        return this.joint;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Consumer consumer = (Consumer)o;
        if (this.connectionId != null ? !this.connectionId.equals(consumer.connectionId) : consumer.connectionId != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(consumer.id) : consumer.id != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(consumer.selector) : consumer.selector != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals((Object)consumer.type) : consumer.type != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.connectionId != null ? this.connectionId.hashCode() : 0);
        result = 31 * result + (this.selector != null ? this.selector.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Consumer{id='" + this.id + '\'' + ", connectionId='" + this.connectionId + '\'' + ", selector='" + this.selector + '\'' + ", joint=" + this.joint + ", lastGetMessageTime=" + this.lastGetMessageTime + ", rebalanceTime=" + this.rebalanceTime + ", maxLockQueues=" + this.maxLockQueues + ", type=" + (Object)((Object)this.type) + ", topic='" + this.topic + '\'' + ", app='" + this.app + '\'' + '}';
    }

    public static enum ConsumeType {
        JOYQUEUE,
        JMQ2,
        KAFKA,
        MQTT,
        INTERNAL;

    }
}

