/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.session;

import org.joyqueue.network.session.Joint;

public class Producer
extends Joint {
    private String id;
    private String connectionId;
    private ProducerType type = ProducerType.JOYQUEUE;

    public Producer() {
    }

    public Producer(String id, String topic, String app, ProducerType type) {
        super(topic, app);
        this.connectionId = id;
        this.id = id;
        this.type = type;
    }

    public Producer(String topic, ProducerType type) {
        this.topic = topic;
        this.type = type;
    }

    public Producer(String topic, String app, ProducerType type) {
        this.topic = topic;
        this.app = app;
        this.type = type;
    }

    public Producer(String id, String connectionId, String topic) {
        this.id = id;
        this.connectionId = connectionId;
        this.topic = topic;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public void setType(ProducerType type) {
        this.type = type;
    }

    public ProducerType getType() {
        return this.type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Producer producer = (Producer)o;
        if (this.connectionId != null ? !this.connectionId.equals(producer.connectionId) : producer.connectionId != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(producer.id) : producer.id != null) {
            return false;
        }
        return !(this.type != null ? this.type.equals((Object)producer.type) : producer.type != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.connectionId != null ? this.connectionId.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Producer{id='" + this.id + '\'' + ", connectionId='" + this.connectionId + '\'' + ", type=" + (Object)((Object)this.type) + ", topic='" + this.topic + '\'' + ", app='" + this.app + '\'' + '}';
    }

    public static enum ProducerType {
        JOYQUEUE,
        JMQ2,
        KAFKA,
        MQTT,
        INTERNAL;

    }
}

