/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.codec;

import io.netty.buffer.ByteBuf;
import org.joyqueue.network.transport.codec.Codec;
import org.joyqueue.network.transport.codec.Encoder;
import org.joyqueue.network.transport.codec.PayloadCodecFactory;
import org.joyqueue.network.transport.codec.PayloadEncoder;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.JoyQueuePayload;
import org.joyqueue.network.transport.command.Payload;
import org.joyqueue.network.transport.exception.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEncoder
implements Encoder {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultEncoder.class);
    private Codec headerCodec;
    private PayloadCodecFactory payloadCodecFactory;

    public DefaultEncoder(Codec headerCodec, PayloadCodecFactory payloadCodecFactory) {
        this.headerCodec = headerCodec;
        this.payloadCodecFactory = payloadCodecFactory;
    }

    @Override
    public void encode(Object obj, ByteBuf buffer) throws TransportException.CodecException {
        try {
            if (!(obj instanceof Command)) {
                throw new TransportException.CodecException(String.format("unsupported encode type, type: %s", obj.getClass()));
            }
            Command response = (Command)obj;
            Header header = response.getHeader();
            Object payload = response.getPayload();
            buffer.writeInt(0);
            if (payload != null) {
                if (!(payload instanceof Payload)) {
                    throw new TransportException.CodecException(String.format("unsupported encode payload type, payload: %s", payload));
                }
                PayloadEncoder encoder = this.payloadCodecFactory.getEncoder(header);
                if (encoder == null) {
                    throw new TransportException.CodecException(String.format("unsupported encode payload type, header: %s", header));
                }
                if (payload instanceof JoyQueuePayload) {
                    ((JoyQueuePayload)payload).setHeader(header);
                }
                int oldVersion = header.getVersion();
                if (payload.getClass().getName().equals("org.joyqueue.nsr.network.command.CreatePartitionGroup") || payload.getClass().getName().equals("org.joyqueue.nsr.network.command.RemovePartitionGroup") || payload.getClass().getName().equals("org.joyqueue.nsr.network.command.UpdatePartitionGroup")) {
                    header.setVersion(2);
                    oldVersion = 2;
                } else {
                    header.setVersion(3);
                }
                this.headerCodec.encode(header, buffer);
                header.setVersion(oldVersion);
                encoder.encode((Payload)payload, buffer);
            } else {
                header.setVersion(3);
                this.headerCodec.encode(header, buffer);
            }
            this.writeLength(obj, buffer);
        }
        catch (Exception e) {
            logger.error("encode exception, payload: {}", obj, (Object)e);
            throw new TransportException.CodecException(e.getMessage());
        }
    }

    protected void writeLength(Object obj, ByteBuf buffer) {
        buffer.setInt(0, buffer.writerIndex());
    }
}

