/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.codec;

import io.netty.buffer.ByteBuf;
import org.joyqueue.domain.QosLevel;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.Codec;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.command.Direction;
import org.joyqueue.network.transport.exception.TransportException;

public class JoyQueueHeaderCodec
implements Codec {
    public static final int HEADER_LENGTH = 19;

    @Override
    public JoyQueueHeader decode(ByteBuf buffer) throws TransportException.CodecException {
        if (buffer.readableBytes() < 19) {
            return null;
        }
        int magic = buffer.readInt();
        if (magic != -889274690) {
            return null;
        }
        byte version = buffer.readByte();
        byte identity = buffer.readByte();
        int requestId = buffer.readInt();
        byte type = buffer.readByte();
        long sendTime = buffer.readLong();
        short status = 0;
        String error = null;
        Direction direction = Direction.valueOf(identity & 1);
        QosLevel qosLevel = QosLevel.valueOf((int)(identity >> 1 & 3));
        if (direction.equals((Object)Direction.RESPONSE)) {
            status = buffer.readUnsignedByte();
            try {
                error = Serializer.readString(buffer, 2);
            }
            catch (Exception e) {
                throw new TransportException.CodecException(e.getMessage());
            }
        }
        return new JoyQueueHeader(version, qosLevel, direction, requestId, type, sendTime, status, error);
    }

    @Override
    public void encode(Object payload, ByteBuf buffer) throws TransportException.CodecException {
        JoyQueueHeader header = (JoyQueueHeader)payload;
        byte identity = (byte)(header.getDirection().ordinal() & 1 | header.getQosLevel().ordinal() << 1 & 6);
        buffer.writeInt(-889274690);
        buffer.writeByte(header.getVersion());
        buffer.writeByte((int)identity);
        buffer.writeInt(header.getRequestId());
        buffer.writeByte(header.getType());
        buffer.writeLong(header.getTime());
        if (header.getDirection().equals((Object)Direction.RESPONSE)) {
            buffer.writeByte(header.getStatus());
            try {
                Serializer.write(header.getError(), buffer, 2);
            }
            catch (Exception e) {
                throw new TransportException.CodecException(e.getMessage());
            }
        }
    }
}

