/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.command.handler.filter;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.joyqueue.network.transport.command.handler.filter.CommandHandlerContext;
import org.joyqueue.network.transport.command.handler.filter.CommandHandlerFilter;
import org.joyqueue.network.transport.exception.TransportException;

public class CommandHandlerInvocation {
    private Transport transport;
    private Command request;
    private CommandHandler commandHandler;
    private Iterator<CommandHandlerFilter> filterIterator;
    private CommandHandlerContext context;

    public CommandHandlerInvocation(Transport transport, Command request, CommandHandler commandHandler, List<CommandHandlerFilter> filterList) {
        this.transport = transport;
        this.request = request;
        this.commandHandler = commandHandler;
        this.filterIterator = CollectionUtils.isEmpty(filterList) ? null : filterList.iterator();
    }

    public Command invoke() throws TransportException {
        if (this.filterIterator == null || !this.filterIterator.hasNext()) {
            return this.commandHandler.handle(this.transport, this.request);
        }
        return this.filterIterator.next().invoke(this);
    }

    public Transport getTransport() {
        return this.transport;
    }

    public Command getRequest() {
        return this.request;
    }

    public CommandHandlerContext getContext() {
        if (this.context == null) {
            this.context = new CommandHandlerContext();
        }
        return this.context;
    }
}

