/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.command.support;

import java.util.List;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.joyqueue.network.transport.command.handler.ExceptionHandler;
import org.joyqueue.network.transport.command.handler.filter.CommandHandlerFilter;
import org.joyqueue.network.transport.command.handler.filter.CommandHandlerFilterFactory;
import org.joyqueue.network.transport.command.handler.filter.CommandHandlerInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandExecuteTask
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(CommandExecuteTask.class);
    private Transport transport;
    private Command request;
    private CommandHandler commandHandler;
    private CommandHandlerFilterFactory commandHandlerFilterFactory;
    private ExceptionHandler exceptionHandler;

    public CommandExecuteTask(Transport transport, Command request, CommandHandler commandHandler, CommandHandlerFilterFactory commandHandlerFilterFactory, ExceptionHandler exceptionHandler) {
        this.transport = transport;
        this.request = request;
        this.commandHandler = commandHandler;
        this.commandHandlerFilterFactory = commandHandlerFilterFactory;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void run() {
        block3: {
            try {
                List<CommandHandlerFilter> commandHandlerFilters = this.commandHandlerFilterFactory.getFilters();
                CommandHandlerInvocation commandHandlerInvocation = new CommandHandlerInvocation(this.transport, this.request, this.commandHandler, commandHandlerFilters);
                Command response = commandHandlerInvocation.invoke();
                if (response != null) {
                    this.transport.acknowledge(this.request, response);
                }
            }
            catch (Throwable t) {
                logger.error("command handler exception, tratnsport: {}, command: {}", new Object[]{this.transport, this.request, t});
                if (this.exceptionHandler == null) break block3;
                this.exceptionHandler.handle(this.transport, this.request, t);
            }
        }
    }
}

