/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.command.support;

import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.joyqueue.network.transport.command.handler.CommandHandlerFactory;
import org.joyqueue.network.transport.command.handler.ExceptionHandler;
import org.joyqueue.network.transport.command.handler.filter.CommandHandlerFilterFactory;
import org.joyqueue.network.transport.command.provider.ExecutorServiceProvider;
import org.joyqueue.network.transport.command.support.CommandExecuteTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandler {
    protected static final Logger logger = LoggerFactory.getLogger(RequestHandler.class);
    private CommandHandlerFactory commandHandlerFactory;
    private CommandHandlerFilterFactory commandHandlerFilterFactory;
    private ExceptionHandler exceptionHandler;

    public RequestHandler(CommandHandlerFactory commandHandlerFactory, CommandHandlerFilterFactory commandHandlerFilterFactory, ExceptionHandler exceptionHandler) {
        this.commandHandlerFactory = commandHandlerFactory;
        this.commandHandlerFilterFactory = commandHandlerFilterFactory;
        this.exceptionHandler = exceptionHandler;
    }

    public void handle(Transport transport, Command request) {
        CommandHandler commandHandler = this.commandHandlerFactory.getHandler(request);
        if (commandHandler == null) {
            logger.error("unsupported command, request: {}", (Object)request);
            return;
        }
        CommandExecuteTask commandExecuteTask = new CommandExecuteTask(transport, request, commandHandler, this.commandHandlerFilterFactory, this.exceptionHandler);
        try {
            if (commandHandler instanceof ExecutorServiceProvider) {
                ((ExecutorServiceProvider)((Object)commandHandler)).getExecutorService(transport, request).execute(commandExecuteTask);
            } else {
                commandExecuteTask.run();
            }
        }
        catch (Throwable t) {
            if (this.exceptionHandler == null) {
                logger.error("command handler exception, transport: {}, request: {}", new Object[]{transport, request, t});
            }
            this.exceptionHandler.handle(transport, request, t);
        }
    }
}

