/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.command.support;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.joyqueue.network.transport.RequestBarrier;
import org.joyqueue.network.transport.ResponseFuture;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.handler.ExceptionHandler;
import org.joyqueue.network.transport.config.TransportConfig;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHandler {
    protected static final Logger logger = LoggerFactory.getLogger(ResponseHandler.class);
    private TransportConfig config;
    private RequestBarrier barrier;
    private ExceptionHandler exceptionHandler;
    private ExecutorService asyncExecutorService;

    public ResponseHandler(TransportConfig transportConfig, RequestBarrier barrier, ExceptionHandler exceptionHandler) {
        this.config = transportConfig;
        this.barrier = barrier;
        this.exceptionHandler = exceptionHandler;
        this.asyncExecutorService = this.newAsyncExecutorService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Transport transport, Command response) {
        Header header = response.getHeader();
        final ResponseFuture responseFuture = this.barrier.get(header.getRequestId());
        if (responseFuture == null) {
            if (logger.isInfoEnabled()) {
                logger.info(String.format("request is timeout %s", header));
            }
            return;
        }
        responseFuture.setResponse(response);
        if (responseFuture.getCallback() != null) {
            boolean success = false;
            ExecutorService executor = this.asyncExecutorService;
            if (executor != null) {
                try {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                responseFuture.onSuccess();
                            }
                            catch (Throwable e) {
                                logger.error("execute callback error.", e);
                            }
                            finally {
                                responseFuture.release();
                            }
                        }
                    });
                    success = true;
                }
                catch (Throwable e) {
                    logger.error("execute callback error.", e);
                }
            }
            if (!success) {
                try {
                    responseFuture.onSuccess();
                }
                catch (Throwable e) {
                    logger.error("execute callback error.", e);
                }
                finally {
                    responseFuture.release();
                }
            }
        } else if (!responseFuture.release()) {
            return;
        }
        this.barrier.remove(header.getRequestId());
    }

    protected ExecutorService newAsyncExecutorService() {
        return Executors.newFixedThreadPool(this.config.getCallbackThreads(), (ThreadFactory)new NamedThreadFactory("joyqueue-async-callback"));
    }
}

