/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.config;

import java.util.List;
import org.joyqueue.network.transport.config.ClientConfig;
import org.joyqueue.network.transport.config.ServerConfig;
import org.joyqueue.network.transport.config.TransportConfig;
import org.joyqueue.toolkit.config.Property;
import org.joyqueue.toolkit.config.PropertySupplier;

public class TransportConfigSupport {
    public static final String TRANSPORT_HOST = "transport.host";
    public static final String TRANSPORT_ACCEPT_THREAD = "transport.acceptThreads";
    public static final String TRANSPORT_IO_THREAD = "transport.ioThreads";
    public static final String TRANSPORT_MAX_IDLE_TIME = "transport.maxIdleTime";
    public static final String TRANSPORT_REUSE_ADDRESS = "transport.reuseAddress";
    public static final String TRANSPORT_SO_LINGER = "transport.soLinger";
    public static final String TRANSPORT_TCP_NO_DELAY = "transport.tcpNoDelay";
    public static final String TRANSPORT_KEEP_ALIVE = "transport.keepAlive";
    public static final String TRANSPORT_SOCKET_TIME_OUT = "transport.socketTimeout";
    public static final String TRANSPORT_SOCKET_BUFFER_SIZE = "transport.socketBufferSize";
    public static final String TRANSPORT_FRAME_MAX_SZE = "transport.frameMaxSize";
    public static final String TRANSPORT_BACKLOG = "transport.backlog";
    public static final String TRANSPORT_MAX_ONEWAY = "transport.maxOneWay";
    public static final String TRANSPORT_MAX_ASYNC = "transport.maxAsync";
    public static final String TRANSPORT_CALL_BACK_THREADS = "transport.callbackThreads";
    public static final String TRANSPORT_CALL_NON_BLOCK_ONEWAY = "transport.nonBlockOneway";
    public static final String TRANSPORT_SEND_TIMEOUT = "transport.sendTimeout";
    public static final String TRANSPORT_RETRY_DELAY = "transport.retryDelay";
    public static final String TRANSPORT_RETRY_MAX = "transport.retryMax";
    public static final String TRANSPORT_SERVER_PORT = "transport.server.port";
    public static final String TRANSPORT_SERVER_HOST = "transport.server.host";
    public static final String TRANSPORT_CLIENT_CONNECT_TIMEOUT = "transport.client.connectTimeout";
    public static final String TRANSPORT_CLIENT_IPV6 = "transport.client.ipv6";

    public static ServerConfig buildServerConfig(PropertySupplier propertySupplier, String keyPrefix) {
        ServerConfig serverConfig = new ServerConfig();
        TransportConfigSupport.buildTransportConfig(propertySupplier, keyPrefix, serverConfig);
        List properties = propertySupplier.getPrefix(keyPrefix);
        if (properties != null) {
            for (Property property : properties) {
                if (property.getKey().equals(keyPrefix + TRANSPORT_SERVER_PORT)) {
                    serverConfig.setPort(property.getInteger());
                    continue;
                }
                if (!property.getKey().equals(keyPrefix + TRANSPORT_SERVER_HOST)) continue;
                serverConfig.setHost(property.getString());
            }
        }
        return serverConfig;
    }

    public static ClientConfig buildClientConfig(PropertySupplier propertySupplier, String keyPrefix) {
        ClientConfig clientConfig = new ClientConfig();
        TransportConfigSupport.buildTransportConfig(propertySupplier, keyPrefix, clientConfig);
        List properties = propertySupplier.getPrefix(keyPrefix);
        if (properties != null) {
            for (Property property : properties) {
                if (property.getKey().equals(keyPrefix + TRANSPORT_CLIENT_IPV6)) {
                    clientConfig.setPreferIPv6(property.getBoolean());
                    continue;
                }
                if (!property.getKey().equals(keyPrefix + TRANSPORT_CLIENT_CONNECT_TIMEOUT)) continue;
                clientConfig.setConnectionTimeout(property.getInteger());
            }
        }
        return clientConfig;
    }

    public static final TransportConfig buildTransportConfig(PropertySupplier propertySupplier, String keyPrefix, TransportConfig transportConfig) {
        List properties = propertySupplier.getPrefix(keyPrefix);
        if (properties != null && !properties.isEmpty()) {
            for (Property property : properties) {
                String fullKey = property.getKey();
                if (fullKey.equals(keyPrefix + TRANSPORT_HOST)) {
                    transportConfig.setHost(property.getString());
                    continue;
                }
                if (fullKey.equals(keyPrefix + TRANSPORT_ACCEPT_THREAD)) {
                    transportConfig.setAcceptThread(property.getInteger());
                    continue;
                }
                if (fullKey.equals(keyPrefix + TRANSPORT_IO_THREAD)) {
                    transportConfig.setIoThread(property.getInteger());
                    continue;
                }
                if (fullKey.equals(keyPrefix + TRANSPORT_MAX_IDLE_TIME)) {
                    transportConfig.setMaxIdleTime(property.getInteger());
                    continue;
                }
                if (fullKey.equals(keyPrefix + TRANSPORT_REUSE_ADDRESS)) {
                    transportConfig.setReuseAddress(property.getBoolean());
                    continue;
                }
                if (fullKey.equals(keyPrefix + TRANSPORT_SO_LINGER)) {
                    transportConfig.setSoLinger(property.getInteger());
                    continue;
                }
                if (fullKey.equals(keyPrefix + TRANSPORT_TCP_NO_DELAY)) {
                    transportConfig.setTcpNoDelay(property.getBoolean());
                    continue;
                }
                if (fullKey.equals(keyPrefix + TRANSPORT_KEEP_ALIVE)) {
                    transportConfig.setKeepAlive(property.getBoolean());
                    continue;
                }
                if (fullKey.equals(keyPrefix + TRANSPORT_SOCKET_TIME_OUT)) {
                    transportConfig.setSoTimeout(property.getInteger());
                    continue;
                }
                if (fullKey.equals(keyPrefix + TRANSPORT_SOCKET_BUFFER_SIZE)) {
                    transportConfig.setSocketBufferSize(property.getInteger());
                    continue;
                }
                if (fullKey.equals(keyPrefix + TRANSPORT_FRAME_MAX_SZE)) {
                    transportConfig.setFrameMaxSize(property.getInteger());
                    continue;
                }
                if (fullKey.equals(keyPrefix + TRANSPORT_BACKLOG)) {
                    transportConfig.setBacklog(property.getInteger());
                    continue;
                }
                if (fullKey.equals(keyPrefix + TRANSPORT_MAX_ONEWAY)) {
                    transportConfig.setMaxOneway(property.getInteger());
                    continue;
                }
                if (fullKey.equals(keyPrefix + TRANSPORT_MAX_ASYNC)) {
                    transportConfig.setMaxAsync(property.getInteger());
                    continue;
                }
                if (fullKey.equals(keyPrefix + TRANSPORT_CALL_BACK_THREADS)) {
                    transportConfig.setCallbackThreads(property.getInteger());
                    continue;
                }
                if (fullKey.equals(keyPrefix + TRANSPORT_CALL_NON_BLOCK_ONEWAY)) {
                    transportConfig.setNonBlockOneway(property.getBoolean());
                    continue;
                }
                if (fullKey.equals(keyPrefix + TRANSPORT_SEND_TIMEOUT)) {
                    transportConfig.setSendTimeout(property.getInteger());
                    continue;
                }
                if (fullKey.equals(keyPrefix + TRANSPORT_RETRY_DELAY)) {
                    transportConfig.getRetryPolicy().setRetryDelay(property.getInteger());
                    continue;
                }
                if (!fullKey.equals(keyPrefix + TRANSPORT_RETRY_MAX)) continue;
                transportConfig.getRetryPolicy().setMaxRetrys(property.getInteger());
            }
        }
        return transportConfig;
    }
}

