/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.exception;

import java.io.IOException;

public class TransportException
extends RuntimeException {
    public static final String UNKNOWN_HOST = "\u65e0\u9650\u4e3b\u673a";
    public static final String CONNECTION_TIMEOUT = "\u8fde\u63a5\u8d85\u65f6";
    public static final String REQUEST_TIMEOUT = "\u8bf7\u6c42\u8d85\u65f6";
    public static final String CONNECTION_ERROR = "\u8fde\u63a5\u9519\u8bef";
    public static final String ILLEGAL_STATE = "\u72b6\u6001\u65e0\u6548";
    public static final String REQUEST_ERROR = "\u8bf7\u6c42\u9519\u8bef";
    public static final String THREAD_EXHAUST = "\u7ebf\u7a0b\u8017\u5c3d";
    public static final String NO_PERMISSION = "\u65e0\u6743\u9650";
    public static final String INVALID_PROTOCOL = "\u65e0\u6548\u534f\u8bae";
    public static final String REQUEST_EXCESSIVE = "\u8bf7\u6c42\u8fc7\u591a";
    public static final String THREAD_INTERRUPTED = "\u7ebf\u7a0b\u88ab\u7ec8\u6b62";
    public static final String CODEC_EXCEPTION = "\u89e3\u7801\u51fa\u9519";
    protected int code;

    public TransportException(Throwable cause) {
        super(cause);
    }

    public TransportException(String message, int code) {
        super(message);
        this.code = code;
    }

    public TransportException(String message, Throwable cause) {
        super(message, cause);
    }

    public TransportException(String message, Throwable cause, int code) {
        super(message, cause);
        this.code = code;
    }

    public TransportException(Throwable cause, int code) {
        super(cause);
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static boolean isClosed(Throwable e) {
        String message;
        if (e == null) {
            return false;
        }
        return e instanceof IOException && ((message = e.getMessage()).contains("Connection reset") || message.contains("Socket closed") || message.contains("\u8fde\u63a5\u88ab\u5bf9\u7aef\u91cd\u7f6e") || message.contains("Connection refused"));
    }

    public static class CodecException
    extends TransportException {
        public CodecException() {
            super(TransportException.CODEC_EXCEPTION, 28);
        }

        public CodecException(String message) {
            super(message, 28);
        }

        public CodecException(Throwable cause) {
            super(cause);
        }

        public static CodecException build() {
            return new CodecException();
        }

        public static CodecException build(String message) {
            return new CodecException(message);
        }
    }

    public static class NoPermissionException
    extends TransportException {
        public NoPermissionException() {
            super(TransportException.NO_PERMISSION, 1);
        }

        public NoPermissionException(String message) {
            super(message, 1);
        }

        public static NoPermissionException build() {
            return new NoPermissionException();
        }

        public static NoPermissionException build(String address) {
            return new NoPermissionException(String.format("\u65e0\u6743\u9650,%s", address));
        }
    }

    public static class InvalidProtocolException
    extends TransportException {
        public InvalidProtocolException() {
            super(TransportException.INVALID_PROTOCOL, 29);
        }

        public static InvalidProtocolException build() {
            return new InvalidProtocolException();
        }
    }

    public static class ThreadExhaustException
    extends TransportException {
        public ThreadExhaustException() {
            super(TransportException.THREAD_EXHAUST, 26);
        }

        public static ThreadExhaustException build() {
            return new ThreadExhaustException();
        }
    }

    public static class InterruptedException
    extends TransportException {
        public InterruptedException() {
            super(TransportException.THREAD_INTERRUPTED, 25);
        }

        public static InterruptedException build() {
            return new InterruptedException();
        }
    }

    public static class IllegalStateException
    extends TransportException {
        public IllegalStateException() {
            super(TransportException.ILLEGAL_STATE, 9);
        }

        public static IllegalStateException build() {
            return new IllegalStateException();
        }
    }

    public static class UnknownException
    extends TransportException {
        public UnknownException() {
            super(TransportException.REQUEST_TIMEOUT, 4);
        }

        public UnknownException(String message) {
            super(message, 4);
        }

        public UnknownException(String message, Throwable cause) {
            super(message, cause, 4);
        }

        public static UnknownException build(String message) {
            return new UnknownException(message);
        }

        public static UnknownException build(Throwable cause) {
            return new UnknownException(cause.getMessage(), cause);
        }
    }

    public static class RequestExcessiveException
    extends RequestErrorException {
        public RequestExcessiveException() {
            super(TransportException.REQUEST_EXCESSIVE, 24);
        }

        public static RequestExcessiveException build() {
            return new RequestExcessiveException();
        }
    }

    public static class RequestTimeoutException
    extends RequestErrorException {
        public RequestTimeoutException() {
            super(TransportException.REQUEST_TIMEOUT, 21);
        }

        public RequestTimeoutException(String message) {
            super(message, 21);
        }

        public static RequestTimeoutException build(String address) {
            return new RequestTimeoutException(String.format("\u8bf7\u6c42\u8d85\u65f6,%s", address));
        }
    }

    public static class RequestErrorException
    extends TransportException {
        public RequestErrorException() {
            super(TransportException.REQUEST_ERROR, 23);
        }

        public RequestErrorException(String message) {
            super(message, 23);
        }

        protected RequestErrorException(String message, int code) {
            super(message, code);
        }

        public RequestErrorException(Throwable cause) {
            super(TransportException.REQUEST_ERROR, cause, 23);
        }

        public RequestErrorException(String message, Throwable cause) {
            super(message, cause, 23);
        }

        public static RequestErrorException build() {
            return new RequestErrorException();
        }

        public static RequestErrorException build(Throwable cause) {
            return new RequestErrorException(cause);
        }

        public static RequestErrorException build(String message) {
            return new RequestErrorException(message);
        }

        public static RequestErrorException build(String message, Throwable cause) {
            return new RequestErrorException(message, cause);
        }
    }

    public static class ConnectionTimeoutException
    extends ConnectionException {
        public ConnectionTimeoutException() {
            super(TransportException.CONNECTION_TIMEOUT, 21);
        }

        public ConnectionTimeoutException(String message) {
            super(message, 21);
        }

        public static ConnectionTimeoutException build(String address) {
            return new ConnectionTimeoutException(String.format("\u8fde\u63a5\u8d85\u65f6,%s", address));
        }
    }

    public static class UnknownHostException
    extends ConnectionException {
        public UnknownHostException() {
            super(TransportException.UNKNOWN_HOST);
        }

        public UnknownHostException(String message) {
            super(message);
        }

        public static UnknownHostException build(String address) {
            return new UnknownHostException(String.format("\u65e0\u9650\u4e3b\u673a,%s", address));
        }
    }

    public static class ConnectionException
    extends TransportException {
        public ConnectionException() {
            super(TransportException.CONNECTION_ERROR, 20);
        }

        public ConnectionException(String message) {
            super(message, 20);
        }

        public ConnectionException(String message, int code) {
            super(message, code);
        }

        public ConnectionException(String message, Throwable t) {
            super(message, t);
        }

        public static ConnectionException build(String address) {
            return new ConnectionException(String.format("\u8fde\u63a5\u9519\u8bef,%s", address));
        }
    }
}

