/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.support;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import java.net.SocketAddress;
import org.joyqueue.network.event.TransportEvent;
import org.joyqueue.network.event.TransportEventHandler;
import org.joyqueue.network.handler.ClientConnectionHandler;
import org.joyqueue.network.transport.RequestBarrier;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.TransportClient;
import org.joyqueue.network.transport.TransportClientSupport;
import org.joyqueue.network.transport.codec.Codec;
import org.joyqueue.network.transport.codec.support.NettyDecoder;
import org.joyqueue.network.transport.codec.support.NettyEncoder;
import org.joyqueue.network.transport.command.support.DefaultCommandDispatcher;
import org.joyqueue.network.transport.command.support.RequestHandler;
import org.joyqueue.network.transport.command.support.ResponseHandler;
import org.joyqueue.network.transport.config.ClientConfig;
import org.joyqueue.network.transport.exception.TransportException;
import org.joyqueue.network.transport.handler.CommandInvocation;
import org.joyqueue.network.transport.support.DefaultChannelTransport;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.joyqueue.toolkit.concurrent.EventListener;

public class DefaultTransportClient
extends TransportClientSupport
implements TransportClient {
    private Codec codec;
    private RequestBarrier requestBarrier;
    private RequestHandler requestHandler;
    private ResponseHandler responseHandler;
    private EventBus<TransportEvent> transportEventBus;

    public DefaultTransportClient(ClientConfig config, Codec codec, RequestBarrier requestBarrier, RequestHandler requestHandler, ResponseHandler responseHandler, EventBus<TransportEvent> transportEventBus) {
        super(config);
        this.codec = codec;
        this.requestBarrier = requestBarrier;
        this.requestHandler = requestHandler;
        this.responseHandler = responseHandler;
        this.transportEventBus = transportEventBus;
        try {
            super.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected ChannelHandler newChannelHandlerPipeline() {
        final DefaultCommandDispatcher commandDispatcher = new DefaultCommandDispatcher(this.requestBarrier, this.requestHandler, this.responseHandler);
        return new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                channel.pipeline().addLast(new ChannelHandler[]{new NettyDecoder(DefaultTransportClient.this.codec)}).addLast(new ChannelHandler[]{new NettyEncoder(DefaultTransportClient.this.codec)}).addLast(new ChannelHandler[]{new ClientConnectionHandler()}).addLast(new ChannelHandler[]{new TransportEventHandler(DefaultTransportClient.this.requestBarrier, (EventBus<TransportEvent>)DefaultTransportClient.this.transportEventBus)}).addLast(new ChannelHandler[]{new CommandInvocation(commandDispatcher)});
            }
        };
    }

    @Override
    public Transport createTransport(String address) throws TransportException {
        return this.createTransport(address, -1L);
    }

    @Override
    public Transport createTransport(String address, long connectionTimeout) throws TransportException {
        return this.createTransport(DefaultTransportClient.createInetSocketAddress(address), connectionTimeout);
    }

    @Override
    public Transport createTransport(SocketAddress address) throws TransportException {
        return this.createTransport(address, -1L);
    }

    @Override
    public Transport createTransport(SocketAddress address, long connectionTimeout) throws TransportException {
        Channel channel = this.createChannel(address, connectionTimeout);
        return new DefaultChannelTransport(channel, this.requestBarrier, address);
    }

    @Override
    public void addListener(EventListener<TransportEvent> listener) {
        this.transportEventBus.addListener(listener);
    }

    @Override
    public void removeListener(EventListener<TransportEvent> listener) {
        this.transportEventBus.removeListener(listener);
    }

    @Override
    protected void doStop() {
        this.requestBarrier.clear();
        super.doStop();
    }
}

