/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.support;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import org.joyqueue.network.event.TransportEvent;
import org.joyqueue.network.event.TransportEventType;
import org.joyqueue.network.transport.ChannelTransport;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.TransportAttribute;
import org.joyqueue.network.transport.TransportClient;
import org.joyqueue.network.transport.TransportState;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.CommandCallback;
import org.joyqueue.network.transport.config.TransportConfig;
import org.joyqueue.network.transport.exception.TransportException;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.joyqueue.toolkit.network.IpUtil;
import org.joyqueue.toolkit.retry.RetryPolicy;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverChannelTransport
implements ChannelTransport {
    protected static final Logger logger = LoggerFactory.getLogger(FailoverChannelTransport.class);
    private volatile ChannelTransport delegate;
    private SocketAddress address;
    private long connectionTimeout;
    private TransportClient transportClient;
    private TransportConfig config;
    private EventBus<TransportEvent> transportEventBus;
    private volatile long lastReconnect;
    private volatile long lastRequest;

    public FailoverChannelTransport(ChannelTransport delegate, SocketAddress address, long connectionTimeout, TransportClient transportClient, TransportConfig config, EventBus<TransportEvent> transportEventBus) {
        this.delegate = delegate;
        this.address = address;
        this.connectionTimeout = connectionTimeout;
        this.transportClient = transportClient;
        this.config = config;
        this.transportEventBus = transportEventBus;
    }

    @Override
    public Channel getChannel() {
        return this.delegate.getChannel();
    }

    @Override
    public Command sync(Command command) throws TransportException {
        return this.sync(command, 0L);
    }

    @Override
    public Command sync(Command command, long timeout) throws TransportException {
        RetryPolicy retryPolicy = this.config.getRetryPolicy();
        TransportException lastException = null;
        Command response = null;
        int retryTimes = 0;
        int retryLimit = retryPolicy.getMaxRetrys();
        for (int i = 0; i <= retryLimit; ++i) {
            try {
                response = this.delegate.sync(command, timeout);
                this.lastRequest = SystemClock.now();
                break;
            }
            catch (TransportException e) {
                if ((!(e instanceof TransportException.RequestTimeoutException) || retryPolicy.getMaxRetryDelay() > 0 && SystemClock.now() - this.lastRequest > (long)retryPolicy.getMaxRetryDelay().intValue()) && !this.tryReconnect()) {
                    throw e;
                }
                lastException = e;
                ++retryTimes;
                continue;
            }
        }
        if (lastException != null && response == null) {
            throw lastException;
        }
        if (lastException != null && logger.isWarnEnabled()) {
            logger.warn("transport sync exception, retry {} times success, command: {}, timeout: {}", new Object[]{retryTimes, command, timeout, lastException});
        }
        return response;
    }

    @Override
    public void async(Command command, CommandCallback callback) throws TransportException {
        this.async(command, 0L, callback);
    }

    @Override
    public void async(Command command, long timeout, CommandCallback callback) throws TransportException {
        if (command == null) {
            throw new IllegalArgumentException("command must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        if (!this.checkChannel()) {
            callback.onException(command, TransportException.RequestErrorException.build(IpUtil.toAddress((SocketAddress)this.address)));
            return;
        }
        this.delegate.async(command, timeout, callback);
    }

    @Override
    public CompletableFuture<?> async(Command command) throws TransportException {
        return this.delegate.async(command);
    }

    @Override
    public CompletableFuture<?> async(Command command, long timeout) throws TransportException {
        return this.delegate.async(command, timeout);
    }

    @Override
    public void oneway(Command command) throws TransportException {
        this.oneway(command, 0L);
    }

    @Override
    public void oneway(Command command, long timeout) throws TransportException {
        this.delegate.oneway(command, timeout);
    }

    @Override
    public void acknowledge(Command request, Command response) throws TransportException {
        this.delegate.acknowledge(request, response);
    }

    @Override
    public void acknowledge(Command request, Command response, CommandCallback callback) throws TransportException {
        this.delegate.acknowledge(request, response, callback);
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.delegate.remoteAddress();
    }

    @Override
    public TransportAttribute attr() {
        return this.delegate.attr();
    }

    @Override
    public void attr(TransportAttribute attribute) {
        this.delegate.attr(attribute);
    }

    @Override
    public TransportState state() {
        return this.delegate.state();
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    public String toString() {
        return this.delegate.toString();
    }

    protected boolean checkChannel() {
        if (this.isChannelActive()) {
            return true;
        }
        return this.tryReconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryReconnect() {
        if (!this.isNeedReconnect()) {
            return false;
        }
        FailoverChannelTransport failoverChannelTransport = this;
        synchronized (failoverChannelTransport) {
            if (this.isNeedReconnect()) {
                return this.reconnect();
            }
            return false;
        }
    }

    protected boolean isChannelActive() {
        return this.delegate.getChannel().isActive();
    }

    protected boolean isNeedReconnect() {
        return SystemClock.now() - this.lastReconnect > (long)this.config.getRetryPolicy().getRetryDelay().intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean reconnect() {
        Transport newTransport = null;
        ChannelTransport oldDelegate = this.delegate;
        try {
            try {
                oldDelegate.stop();
            }
            catch (Throwable t) {
                logger.warn("stop transport exception, transport: {}", (Object)oldDelegate, (Object)t);
            }
            newTransport = (ChannelTransport)this.transportClient.createTransport(this.address, this.connectionTimeout);
            if (logger.isInfoEnabled()) {
                logger.info("reconnect transport success, transport: {}", (Object)newTransport);
            }
            this.delegate = newTransport;
            this.transportEventBus.inform((Object)new TransportEvent(TransportEventType.RECONNECT, this));
            boolean t = true;
            return t;
        }
        catch (Throwable t) {
            if (logger.isDebugEnabled()) {
                logger.debug("reconnect transport exception, address: {}", (Object)this.address, (Object)t);
            }
            if (newTransport != null) {
                try {
                    newTransport.stop();
                }
                catch (Exception e) {
                    logger.warn("stop newTransport exception, transport: {}", (Object)newTransport, (Object)t);
                }
                this.delegate = oldDelegate;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lastReconnect = SystemClock.now();
        }
    }
}

