/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.iam;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.ligoj.app.iam.CompanyOrg;
import org.ligoj.app.iam.GroupOrg;
import org.ligoj.app.iam.ICompanyRepository;
import org.ligoj.app.iam.UserOrg;
import org.ligoj.bootstrap.core.validation.ValidationJsonException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public interface IUserRepository {
    public UserOrg findByIdNoCache(String var1);

    default public UserOrg findOneBy(String attribute, String value) {
        return this.findAllBy(attribute, value).stream().findFirst().orElse(null);
    }

    public List<UserOrg> findAllBy(String var1, String var2);

    public Map<String, UserOrg> findAll();

    default public UserOrg findById(String id) {
        return this.findAll().get(id);
    }

    default public UserOrg findByIdExpected(String id) {
        return Optional.ofNullable(this.findById(id)).orElseThrow(() -> new ValidationJsonException("id", (Serializable)((Object)"unknown-id"), new Serializable[]{"0", "user", "1", id}));
    }

    public ICompanyRepository getCompanyRepository();

    default public UserOrg findByIdExpected(String principal, String id) {
        UserOrg rawUserLdap = this.findByIdExpected(id);
        if (this.getCompanyRepository().findById(principal, rawUserLdap.getCompany()) == null) {
            throw new ValidationJsonException("id", (Serializable)((Object)"unknown-id"), new Serializable[]{"0", "user", "1", principal});
        }
        return rawUserLdap;
    }

    public Page<UserOrg> findAll(Collection<GroupOrg> var1, Set<String> var2, String var3, Pageable var4);

    public boolean authenticate(String var1, String var2);

    public String getToken(String var1);

    public void setPassword(UserOrg var1, String var2);

    default public UserOrg toUser(String id) {
        if (id == null) {
            return null;
        }
        UserOrg result = this.findById(id);
        if (result == null) {
            result = new UserOrg();
            result.setId(id);
        }
        return result;
    }

    public String getPeopleInternalBaseDn();

    public void updateUser(UserOrg var1);

    public void move(UserOrg var1, CompanyOrg var2);

    public void restore(UserOrg var1);

    public void unlock(UserOrg var1);

    public void isolate(String var1, UserOrg var2);

    public void lock(String var1, UserOrg var2);

    public void delete(UserOrg var1);

    public void updateMembership(Collection<String> var1, UserOrg var2);

    public UserOrg create(UserOrg var1);

    public String toDn(UserOrg var1);
}

