/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.validation;

import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.app.validation.DistinguishName;

public class DistinguishNameValidator
implements ConstraintValidator<DistinguishName, String> {
    private static final String VALUE = "[\\p{L}\\d][\\p{L}\\d\\-:_ ]*";
    private static final String KEY_VALUE = "[\\p{L}\\d][\\p{L}\\d\\-:_ ]*=\\s*[\\p{L}\\d][\\p{L}\\d\\-:_ ]*";
    private static final Pattern DN_PATTERN = Pattern.compile("([\\p{L}\\d][\\p{L}\\d\\-:_ ]*=\\s*[\\p{L}\\d][\\p{L}\\d\\-:_ ]*(,\\s*[\\p{L}\\d][\\p{L}\\d\\-:_ ]*=\\s*[\\p{L}\\d][\\p{L}\\d\\-:_ ]*)*)?");

    public void initialize(DistinguishName annotation) {
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        try {
            String dn = StringUtils.trimToEmpty((String)value);
            new LdapName(dn);
            return DN_PATTERN.matcher(dn).matches();
        }
        catch (InvalidNameException ne) {
            return false;
        }
    }
}

