/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.api;

import jakarta.validation.constraints.NotNull;
import java.text.Normalizer;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public final class Normalizer {
    private Normalizer() {
    }

    public static Set<String> normalize(Collection<String> items) {
        return Normalizer.normalize(CollectionUtils.emptyIfNull(items).stream());
    }

    public static Set<String> normalize(Stream<String> items) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        items.map(Normalizer::normalize).forEach(result::add);
        return result;
    }

    public static String normalize(@NotNull String item) {
        return java.text.Normalizer.normalize(StringUtils.trimToEmpty((String)item), Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "").toLowerCase(Locale.ENGLISH);
    }
}

