/*
 * Decompiled with CFR 0.152.
 */
package org.linuxmce.dce;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.linuxmce.dce.Connection;
import org.linuxmce.dce.DCEConnectionException;
import org.linuxmce.dce.Message;
import org.linuxmce.dce.MessageDeserializer;
import org.linuxmce.dce.util.BinaryData;

public abstract class ConnectionMonitor {
    public static final String MESSAGE_HEADER = "MESSAGE";
    private String name;
    private Connection connection;
    private MessageDeserializer deserializer;

    public abstract void setup(InputStream var1, OutputStream var2) throws IOException;

    public abstract void onMessage(Message var1) throws IOException;

    public ConnectionMonitor(String name, Connection connection, MessageDeserializer deserializer) {
        this.deserializer = deserializer;
        this.name = name;
        this.connection = connection;
    }

    void connect() throws IOException {
        final OutputStream write = this.connection.getOutputStream();
        InputStream read = this.connection.getInputStream();
        try {
            this.setup(read, write);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.connection.close();
            return;
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        while (true) {
                            BinaryData data = ConnectionMonitor.this.readMessage();
                            Message message = ConnectionMonitor.this.deserializer.deserialize(data);
                            if (message != null) {
                                write.write("OK\n".getBytes());
                                write.flush();
                            }
                            ConnectionMonitor.this.onMessage(message);
                        }
                    }
                    catch (Exception ex) {
                        try {
                            ConnectionMonitor.this.onMessage(null);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            ConnectionMonitor.this.connection.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Throwable throwable) {
                    try {
                        ConnectionMonitor.this.connection.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }.start();
    }

    public BinaryData readMessage() throws IOException {
        String header = this.readLine().trim();
        if (header.indexOf("MESSAGE ") > 0) {
            throw new DCEConnectionException("Not a Message Header [" + this.name + "] - '" + header + "'");
        }
        String sSize = header.substring(MESSAGE_HEADER.length() + 1);
        int messageSize = Integer.parseInt(sSize);
        BinaryData data = new BinaryData();
        byte[] buff = new byte[messageSize];
        try {
            for (int pos = 0; pos < messageSize; ++pos) {
                int c = this.connection.getInputStream().read();
                if (c == -1) {
                    throw new DCEConnectionException("Not connected to DCERouter - Connection has been closed remotely");
                }
                buff[pos] = (byte)c;
            }
            data.write(buff);
        }
        catch (Exception e) {
            throw new DCEConnectionException("Not connected to DCERouter", e);
        }
        data.resetPosition();
        return data;
    }

    String readLine() throws IOException {
        StringBuilder buf = new StringBuilder();
        char c = '\uffff';
        while (c != '\n' && c != '\u0000') {
            c = (char)this.connection.getInputStream().read();
            if (c == '\uffffffff' || c > '\u00ff') {
                throw new DCEConnectionException("Not connected to DCERouter [" + this.name + "], connection closed remotely");
            }
            if (c == 10 || c == '\u0000') continue;
            buf.append(c);
        }
        return buf.toString();
    }

    void writeBytes(byte[] bytes) throws IOException {
        this.connection.getOutputStream().write(bytes);
        this.connection.getOutputStream().flush();
    }
}

