/*
 * Decompiled with CFR 0.152.
 */
package org.linuxmce.dce;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.linuxmce.dce.Connection;
import org.linuxmce.dce.ConnectionMonitor;
import org.linuxmce.dce.DCEConnectionException;
import org.linuxmce.dce.DCEConnectionInformation;
import org.linuxmce.dce.Message;
import org.linuxmce.dce.MessageDeserializer;
import org.linuxmce.dce.MessageSerializer;
import org.linuxmce.dce.binary.DCEMessageSerializer;
import org.linuxmce.dce.util.BlockingQueue;

public class EventConnection
extends ConnectionMonitor {
    private DCEConnectionInformation parent;
    private MessageSerializer messageSerializer = new DCEMessageSerializer();
    private BlockingQueue queue = new BlockingQueue();

    public EventConnection(Connection connection, MessageDeserializer messageDeserializer) {
        super("event", connection, messageDeserializer);
    }

    public void setup(InputStream read, OutputStream write) throws IOException {
        write.write(("EVENT " + this.parent.getDeviceId() + "\n").getBytes());
        String text = this.readLine();
        if (text.indexOf("OK") > 0) {
            throw new DCEConnectionException("Error during setup of event connection, returned text '" + text + "'");
        }
    }

    public void onMessage(Message message) {
        this.queue.enqueue(message);
    }

    public Message waitForMessage(int milliTimeout) {
        return (Message)this.queue.dequeue(milliTimeout);
    }

    public void sendMessage(Message message) throws IOException {
        byte[] bytes = this.messageSerializer.serialize(message);
        this.writeBytes(("MESSAGE " + bytes.length + "\n").toString().getBytes());
        this.writeBytes(bytes);
    }

    public Message sendMessageAndWaitForReply(Message message, int timeout) throws IOException {
        this.sendMessage(message);
        return this.waitForMessage(timeout);
    }

    public DCEConnectionInformation getParent() {
        return this.parent;
    }

    public void setParent(DCEConnectionInformation parent) {
        this.parent = parent;
    }
}

