/*
 * Decompiled with CFR 0.152.
 */
package org.linuxmce.dce.util;

import java.util.Arrays;

public class BinaryData {
    public static int DATA_BLOCK = 4096;
    byte[] data = null;
    int position = 0;

    public BinaryData() {
        this.data = new byte[DATA_BLOCK];
    }

    public BinaryData(byte[] pData) {
        this.data = pData;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getPosition() {
        return this.position;
    }

    private void increaseSize() {
        this.data = Arrays.copyOf(this.data, this.data.length + DATA_BLOCK);
    }

    public BinaryData write(byte[] pSmallData) {
        if (this.position + pSmallData.length > this.data.length) {
            this.increaseSize();
        }
        for (int i = 0; i < pSmallData.length; ++i) {
            this.data[this.position + i] = pSmallData[i];
        }
        this.position += pSmallData.length;
        return this;
    }

    public BinaryData writeFront(byte[] pSmallData) {
        int nNewLength = this.data.length;
        if (this.position + pSmallData.length > this.data.length) {
            nNewLength = this.position + pSmallData.length;
        }
        byte[] pNewData = new byte[nNewLength];
        for (int i = 0; i < pSmallData.length; ++i) {
            pNewData[i] = pSmallData[i];
        }
        for (int j = 0; j < this.position; ++j) {
            pNewData[pSmallData.length + j] = this.data[j];
        }
        this.data = pNewData;
        this.position += pSmallData.length;
        return this;
    }

    public byte[] read(int nBytes) {
        byte[] pSmallData = new byte[nBytes];
        if (this.position + nBytes < this.data.length) {
            for (int i = 0; i < nBytes; ++i) {
                pSmallData[i] = this.data[this.position + i];
            }
            this.position += nBytes;
        } else {
            System.out.println("Cannot serialize object from position " + new Integer(this.position).toString() + " bytes to read " + new Integer(nBytes).toString());
        }
        return pSmallData;
    }

    public String readString() {
        String sResult = new String();
        for (int i = this.position; i < this.data.length; ++i) {
            if (this.data[i] == 0) {
                this.position = i + 1;
                break;
            }
            sResult = sResult + (char)this.data[i];
        }
        return sResult;
    }

    public void resetPosition() {
        this.position = 0;
    }
}

