/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.http;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.maproulette.client.exception.MapRouletteException;

public abstract class HttpResource
implements Closeable {
    private HttpRequestBase request;
    private final URI uri;
    private CloseableHttpResponse response = null;
    private UsernamePasswordCredentials creds = null;
    private HttpHost proxy = null;

    private static HttpClientContext createBasicAuthCache(HttpHost target, HttpClientContext context) {
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(target, (AuthScheme)basicAuth);
        context.setAuthCache((AuthCache)authCache);
        return context;
    }

    public HttpResource(String uri) {
        this(URI.create(uri));
    }

    public HttpResource(URI uri) {
        this.uri = uri;
    }

    @Override
    public void close() {
        HttpClientUtils.closeQuietly((CloseableHttpResponse)this.response);
    }

    public void execute() throws MapRouletteException {
        this.response = null;
        this.response();
    }

    public Header[] getHeader(String headerKey) throws MapRouletteException {
        this.response();
        return this.response.getHeaders(headerKey);
    }

    public String getRequestBodyAsString() throws MapRouletteException {
        try {
            return new String(this.response().readAllBytes());
        }
        catch (IOException e) {
            throw new MapRouletteException(e);
        }
    }

    public CloseableHttpResponse getResponse() throws MapRouletteException {
        this.response();
        return this.response;
    }

    public int getStatusCode() throws MapRouletteException {
        this.response();
        return this.response.getStatusLine().getStatusCode();
    }

    public void setAuth(String user, String pass) {
        this.creds = new UsernamePasswordCredentials(user, pass);
    }

    public void setHeader(String name, String value) {
        this.request.setHeader(name, value);
    }

    private InputStream response() throws MapRouletteException {
        try {
            if (this.response == null) {
                HttpHost target = new HttpHost(this.uri.getHost(), this.uri.getPort(), this.uri.getScheme());
                HttpClientContext context = HttpClientContext.create();
                HttpClientBuilder clientBuilder = HttpClients.custom();
                if (this.creds != null) {
                    BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                    credsProvider.setCredentials(new AuthScope(target.getHostName(), target.getPort()), (Credentials)this.creds);
                    clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                }
                if (this.proxy != null) {
                    clientBuilder.setProxy(this.proxy);
                }
                CloseableHttpClient client = clientBuilder.build();
                HttpResource.createBasicAuthCache(target, context);
                this.response = client.execute(target, (HttpRequest)this.request, (HttpContext)context);
            }
            if (this.response.getEntity() == null) {
                return new ByteArrayInputStream("".getBytes());
            }
            return this.response.getEntity().getContent();
        }
        catch (IOException ioe) {
            throw new MapRouletteException(ioe.getMessage(), ioe);
        }
    }

    public void setRequest(HttpRequestBase request) {
        this.request = request;
    }

    public HttpRequestBase getRequest() {
        return this.request;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setProxy(HttpHost proxy) {
        this.proxy = proxy;
    }
}

