/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.connection;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.maproulette.client.exception.MapRouletteException;
import org.maproulette.client.http.HttpResource;
import org.maproulette.client.http.PostResource;
import org.maproulette.client.http.ResourceFactory;

public class Query {
    private String methodName;
    private String data;
    private ContentType dataContentType;
    private final String uri;
    private final Map<String, String> queryParameters = new HashMap<String, String>();
    private final Map<String, String> headers = new HashMap<String, String>();

    public void addParameter(String key, String value) {
        this.queryParameters.put(key, value);
    }

    public void addHeader(String header, String value) {
        this.headers.put(header, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<String> execute(ResourceFactory factory, URIBuilder uriBuilder, Function<HttpResource, String> function) throws MapRouletteException {
        URIBuilder path = uriBuilder.setPath(this.uri);
        if (!this.queryParameters.isEmpty()) {
            this.queryParameters.forEach((arg_0, arg_1) -> ((URIBuilder)path).setParameter(arg_0, arg_1));
        }
        try (HttpResource resource = factory.resource(this.methodName, path.build());){
            String result;
            if (StringUtils.isNotEmpty((String)this.data) && resource instanceof PostResource) {
                ((PostResource)resource).setStringBody(this.data, this.dataContentType);
            }
            if (!this.headers.isEmpty()) {
                this.headers.forEach(resource::setHeader);
            }
            if ((result = function.apply(resource)).isEmpty()) {
                Optional<String> optional = Optional.empty();
                return optional;
            }
            Optional<String> optional = Optional.of(result);
            return optional;
        }
        catch (URISyntaxException e) {
            throw new MapRouletteException(e);
        }
    }

    private static String $default$methodName() {
        return "GET";
    }

    private static String $default$data() {
        return "";
    }

    private static ContentType $default$dataContentType() {
        return ContentType.APPLICATION_JSON;
    }

    Query(String methodName, String data, ContentType dataContentType, String uri) {
        this.methodName = methodName;
        this.data = data;
        this.dataContentType = dataContentType;
        this.uri = uri;
    }

    public static QueryBuilder builder() {
        return new QueryBuilder();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getData() {
        return this.data;
    }

    public ContentType getDataContentType() {
        return this.dataContentType;
    }

    public String getUri() {
        return this.uri;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public static class QueryBuilder {
        private boolean methodName$set;
        private String methodName$value;
        private boolean data$set;
        private String data$value;
        private boolean dataContentType$set;
        private ContentType dataContentType$value;
        private String uri;

        public QueryBuilder post(String uri) {
            this.uri(uri);
            this.methodName("POST");
            return this;
        }

        public QueryBuilder get(String uri) {
            this.uri(uri);
            this.methodName("GET");
            return this;
        }

        public QueryBuilder put(String uri) {
            this.uri(uri);
            this.methodName("PUT");
            return this;
        }

        public QueryBuilder delete(String uri) {
            this.uri(uri);
            this.methodName("DELETE");
            return this;
        }

        QueryBuilder() {
        }

        public QueryBuilder methodName(String methodName) {
            this.methodName$value = methodName;
            this.methodName$set = true;
            return this;
        }

        public QueryBuilder data(String data) {
            this.data$value = data;
            this.data$set = true;
            return this;
        }

        public QueryBuilder dataContentType(ContentType dataContentType) {
            this.dataContentType$value = dataContentType;
            this.dataContentType$set = true;
            return this;
        }

        public QueryBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public Query build() {
            String methodName$value = this.methodName$value;
            if (!this.methodName$set) {
                methodName$value = Query.$default$methodName();
            }
            String data$value = this.data$value;
            if (!this.data$set) {
                data$value = Query.$default$data();
            }
            ContentType dataContentType$value = this.dataContentType$value;
            if (!this.dataContentType$set) {
                dataContentType$value = Query.$default$dataContentType();
            }
            return new Query(methodName$value, data$value, dataContentType$value, this.uri);
        }

        public String toString() {
            return "Query.QueryBuilder(methodName$value=" + this.methodName$value + ", data$value=" + this.data$value + ", dataContentType$value=" + this.dataContentType$value + ", uri=" + this.uri + ")";
        }
    }
}

