/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.model;

import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.maproulette.client.exception.MapRouletteRuntimeException;
import org.maproulette.client.model.PriorityRule;
import org.maproulette.client.utilities.ObjectMapperSingleton;

@JsonDeserialize(using=RuleListDeserializer.class)
@JsonSerialize(using=RuleListSerializer.class)
public class RuleList
implements Serializable {
    private static final String KEY_CONDITION = "condition";
    private static final String KEY_RULES = "rules";
    private static final long serialVersionUID = -1085774480815117637L;
    private String condition;
    private List<RuleList> ruleList;
    private List<PriorityRule> rules;

    public boolean isSet() {
        return this.condition != null && this.rules != null && !this.rules.isEmpty();
    }

    @JsonValue
    public String toJson() {
        try {
            return ObjectMapperSingleton.getMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new MapRouletteRuntimeException(e);
        }
    }

    public static RuleListBuilder builder() {
        return new RuleListBuilder();
    }

    public String getCondition() {
        return this.condition;
    }

    public List<RuleList> getRuleList() {
        return this.ruleList;
    }

    public List<PriorityRule> getRules() {
        return this.rules;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void setRuleList(List<RuleList> ruleList) {
        this.ruleList = ruleList;
    }

    public void setRules(List<PriorityRule> rules) {
        this.rules = rules;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuleList)) {
            return false;
        }
        RuleList other = (RuleList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$condition = this.getCondition();
        String other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        List<RuleList> this$ruleList = this.getRuleList();
        List<RuleList> other$ruleList = other.getRuleList();
        if (this$ruleList == null ? other$ruleList != null : !((Object)this$ruleList).equals(other$ruleList)) {
            return false;
        }
        List<PriorityRule> this$rules = this.getRules();
        List<PriorityRule> other$rules = other.getRules();
        return !(this$rules == null ? other$rules != null : !((Object)this$rules).equals(other$rules));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuleList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        List<RuleList> $ruleList = this.getRuleList();
        result = result * 59 + ($ruleList == null ? 43 : ((Object)$ruleList).hashCode());
        List<PriorityRule> $rules = this.getRules();
        result = result * 59 + ($rules == null ? 43 : ((Object)$rules).hashCode());
        return result;
    }

    public String toString() {
        return "RuleList(condition=" + this.getCondition() + ", ruleList=" + this.getRuleList() + ", rules=" + this.getRules() + ")";
    }

    public RuleList() {
    }

    public RuleList(String condition, List<RuleList> ruleList, List<PriorityRule> rules) {
        this.condition = condition;
        this.ruleList = ruleList;
        this.rules = rules;
    }

    public static class RuleListBuilder {
        private String condition;
        private List<RuleList> ruleList;
        private List<PriorityRule> rules;

        RuleListBuilder() {
        }

        public RuleListBuilder condition(String condition) {
            this.condition = condition;
            return this;
        }

        public RuleListBuilder ruleList(List<RuleList> ruleList) {
            this.ruleList = ruleList;
            return this;
        }

        public RuleListBuilder rules(List<PriorityRule> rules) {
            this.rules = rules;
            return this;
        }

        public RuleList build() {
            return new RuleList(this.condition, this.ruleList, this.rules);
        }

        public String toString() {
            return "RuleList.RuleListBuilder(condition=" + this.condition + ", ruleList=" + this.ruleList + ", rules=" + this.rules + ")";
        }
    }

    public static class RuleListDeserializer
    extends StdDeserializer<RuleList> {
        public RuleListDeserializer() {
            this(null);
        }

        public RuleListDeserializer(Class<?> valueClass) {
            super(valueClass);
        }

        private static RuleList buildRuleListHelper(JsonNode node, DeserializationContext ctxt) {
            if (node.get(RuleList.KEY_CONDITION) == null) {
                return null;
            }
            RuleList ret = RuleList.builder().condition(node.get(RuleList.KEY_CONDITION).asText()).ruleList(new ArrayList<RuleList>()).rules(new ArrayList<PriorityRule>()).build();
            for (JsonNode jsonNode : node.withArray(RuleList.KEY_RULES)) {
                if (jsonNode.get(RuleList.KEY_CONDITION) != null) {
                    RuleList child = RuleListDeserializer.buildRuleListHelper(jsonNode, ctxt);
                    ret.getRuleList().add(child);
                    continue;
                }
                PriorityRule priorityRule = PriorityRule.builder().type(jsonNode.get("type").asText()).operator(jsonNode.get("operator").asText()).value(jsonNode.get("value").asText()).build();
                ret.getRules().add(priorityRule);
            }
            return ret;
        }

        public RuleList deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RuleListDeserializer.buildRuleListHelper(node, ctxt);
        }
    }

    public static class RuleListSerializer
    extends StdSerializer<RuleList> {
        public RuleListSerializer() {
            this(null);
        }

        public RuleListSerializer(Class<RuleList> clazzRuleList) {
            super(clazzRuleList);
        }

        private static void serializeRuleListHelper(List<RuleList> ruleListList, JsonGenerator gen) throws IOException {
            for (RuleList ruleList : ruleListList) {
                gen.writeStartObject();
                gen.writeStringField(RuleList.KEY_CONDITION, ruleList.getCondition());
                gen.writeArrayFieldStart(RuleList.KEY_RULES);
                if (ruleList.getRuleList() != null) {
                    for (RuleList nestedRuleList : ruleList.getRuleList()) {
                        RuleListSerializer.serializeRuleListHelper(nestedRuleList.getRuleList(), gen);
                    }
                }
                if (ruleList.getRules() != null) {
                    for (PriorityRule priorityRule : ruleList.getRules()) {
                        gen.writeObject((Object)priorityRule);
                    }
                }
                gen.writeEndArray();
                gen.writeEndObject();
            }
        }

        public void serialize(RuleList value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeStartObject();
            gen.writeStringField(RuleList.KEY_CONDITION, value.getCondition());
            gen.writeArrayFieldStart(RuleList.KEY_RULES);
            if (value.getRuleList() != null) {
                RuleListSerializer.serializeRuleListHelper(value.getRuleList(), gen);
            }
            if (value.getRules() != null) {
                for (PriorityRule priorityRule : value.getRules()) {
                    gen.writeObject((Object)priorityRule);
                }
            }
            gen.writeEndArray();
            gen.writeEndObject();
        }
    }
}

