/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.batch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.maproulette.client.api.ChallengeAPI;
import org.maproulette.client.connection.IMapRouletteConnection;
import org.maproulette.client.connection.MapRouletteConfiguration;
import org.maproulette.client.connection.MapRouletteConnection;
import org.maproulette.client.connection.Query;
import org.maproulette.client.exception.MapRouletteException;
import org.maproulette.client.exception.MapRouletteRuntimeException;
import org.maproulette.client.model.Challenge;
import org.maproulette.client.model.Task;
import org.maproulette.client.utilities.ObjectMapperSingleton;
import org.maproulette.client.utilities.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChallengeBatch {
    private static final int MAXIMUM_BATCH_SIZE = 500;
    private final Logger logger = LoggerFactory.getLogger(ChallengeBatch.class);
    private final ObjectMapper mapper = ObjectMapperSingleton.getMapper();
    private final IMapRouletteConnection connection;
    private final long challengeId;
    private final int maxBatchSize;
    private final List<Task> batch = new ArrayList<Task>();

    public static long getChallengeId(MapRouletteConfiguration configuration, Challenge challenge) {
        ChallengeAPI challengeAPI = new ChallengeAPI(configuration);
        try {
            Optional<Challenge> batchChallenge = challengeAPI.get(challenge.getParent(), challenge.getName());
            if (batchChallenge.isEmpty()) {
                Challenge newChallenge = challengeAPI.create(challenge);
                return newChallenge.getId();
            }
            return batchChallenge.get().getId();
        }
        catch (MapRouletteException e) {
            throw new MapRouletteRuntimeException(e);
        }
    }

    public ChallengeBatch(MapRouletteConfiguration configuration, long challengeId) {
        this(new MapRouletteConnection(configuration), challengeId, configuration.getBatchSize());
    }

    public ChallengeBatch(MapRouletteConfiguration configuration, Challenge challenge) {
        this.connection = new MapRouletteConnection(configuration);
        this.maxBatchSize = configuration.getBatchSize();
        this.challengeId = ChallengeBatch.getChallengeId(configuration, challenge);
    }

    public synchronized void addTasks(List<Task> tasks) throws MapRouletteException {
        tasks.forEach(ThrowingConsumer.throwingConsumerWrapper(this::addTask));
    }

    public synchronized void addTask(Task task) throws MapRouletteException {
        task.setParent(this.challengeId);
        this.batch.add(task);
        if (this.batch.size() >= this.maxBatchSize) {
            this.logger.debug("FLUSHING queued tasks as batch size {} meets max {}", (Object)this.batch.size(), (Object)this.maxBatchSize);
            this.flush();
        }
    }

    public synchronized void flush() throws MapRouletteException {
        if (!this.batch.isEmpty()) {
            this.uploadBatchTasks(this.challengeId, this.batch);
            this.batch.clear();
        }
    }

    private boolean uploadBatchTasks(long challengeId, List<Task> data) throws MapRouletteException {
        int endIndex;
        ArrayList<Task> uniqueTasks = new ArrayList<Task>(data.size());
        uniqueTasks.addAll(data);
        boolean succeeded = true;
        int startIndex = 0;
        do {
            endIndex = Math.min(startIndex + 500, uniqueTasks.size());
            List<Task> uploadList = uniqueTasks.subList(startIndex, endIndex);
            succeeded &= this.internalUploadBatchTasks(challengeId, uploadList);
        } while (endIndex != uniqueTasks.size() - 1 && (startIndex += 500) < uniqueTasks.size());
        return succeeded;
    }

    private boolean internalUploadBatchTasks(long parentChallengeId, List<Task> data) throws MapRouletteException {
        if (data.isEmpty()) {
            return false;
        }
        this.logger.debug("Uploading batch of {} tasks for challenge {}", (Object)data.size(), (Object)parentChallengeId);
        try {
            ArrayNode postData = this.mapper.createArrayNode();
            data.forEach(task -> postData.add((JsonNode)this.mapper.convertValue(task, JsonNode.class)));
            String postDataString = this.mapper.writeValueAsString((Object)postData);
            Query query = Query.builder().post("/api/v2/tasks").data(postDataString).build();
            this.connection.execute(query);
            return true;
        }
        catch (JsonProcessingException e) {
            throw new MapRouletteException(e);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public IMapRouletteConnection getConnection() {
        return this.connection;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public long getChallengeId() {
        return this.challengeId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<Task> getBatch() {
        return this.batch;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ChallengeBatch(IMapRouletteConnection connection, long challengeId, int maxBatchSize) {
        this.connection = connection;
        this.challengeId = challengeId;
        this.maxBatchSize = maxBatchSize;
    }
}

