/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang.StringUtils;

public enum ChallengePriority {
    NONE(-1),
    HIGH(0),
    MEDIUM(1),
    LOW(2);

    private final int value;

    @JsonCreator
    public static ChallengePriority fromValue(String value) {
        try {
            int intValue = Integer.parseInt(value);
            return ChallengePriority.fromValue(intValue);
        }
        catch (NumberFormatException e) {
            for (ChallengePriority challengePriority : ChallengePriority.values()) {
                if (!StringUtils.equalsIgnoreCase((String)challengePriority.name(), (String)value)) continue;
                return challengePriority;
            }
            return null;
        }
    }

    public static ChallengePriority fromValue(int value) {
        for (ChallengePriority challengePriority : ChallengePriority.values()) {
            if (challengePriority.intValue() != value) continue;
            return challengePriority;
        }
        return LOW;
    }

    private ChallengePriority(int value) {
        this.value = value;
    }

    @JsonValue
    public int intValue() {
        return this.value;
    }
}

