/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.connection;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.maproulette.client.exception.MapRouletteException;

public class MapRouletteConfiguration
implements Serializable {
    private static final int DEFAULT_BATCH_SIZE = 500;
    private static final int API_KEY_INDEX = 3;
    private static final int NUMBER_OF_COMPONENTS = 4;
    private static final int PORT_INDEX = 1;
    private static final int PROJECT_NAME_INDEX = 2;
    private static final int SERVER_INDEX = 0;
    private static final long serialVersionUID = -1060265212173405828L;
    private static final String DELIMITER = "(?<!https|http):";
    private static final String SCHEME_DELIMITER = "://";
    private final String apiKey;
    private final int port;
    private final String scheme;
    private final String server;
    private final String defaultProjectName;
    private int batchSize;

    public static MapRouletteConfiguration parse(String configuration) throws MapRouletteException {
        String[] components;
        if (StringUtils.isNotEmpty((String)configuration) && (components = configuration.split(DELIMITER)).length == 4) {
            String server;
            String scheme;
            String[] splitServer = components[0].split(SCHEME_DELIMITER);
            if (splitServer.length < 2) {
                scheme = "http";
                server = components[0];
            } else {
                scheme = splitServer[0];
                server = splitServer[1];
            }
            return new MapRouletteConfiguration(scheme, server, Integer.parseInt(components[1]), components[2], components[3]);
        }
        throw new MapRouletteException(String.format("Map Roulette configuration not set, invalid string passed in. [%s]", configuration));
    }

    public MapRouletteConfiguration(String server, int port, String projectName, String apiKey) {
        this("https", server, port, projectName, apiKey);
    }

    public MapRouletteConfiguration(String server, int port, String apiKey) {
        this("https", server, port, apiKey);
    }

    public MapRouletteConfiguration(String scheme, String server, int port, String projectName, String apiKey) {
        this.scheme = scheme;
        this.server = server;
        this.port = port;
        this.defaultProjectName = projectName;
        this.apiKey = apiKey;
        this.batchSize = 500;
    }

    public MapRouletteConfiguration(String scheme, String server, int port, String apiKey) {
        this.scheme = scheme;
        this.server = server;
        this.port = port;
        this.defaultProjectName = "";
        this.apiKey = apiKey;
        this.batchSize = 500;
    }

    public String toString() {
        return String.format("%s://%s:%d:%s:%s", this.scheme, this.server, this.port, this.defaultProjectName, this.apiKey);
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public int getPort() {
        return this.port;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServer() {
        return this.server;
    }

    public String getDefaultProjectName() {
        return this.defaultProjectName;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }
}

