/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Arrays;
import lombok.NonNull;
import org.maproulette.client.exception.MapRouletteException;
import org.maproulette.client.model.ChallengeDifficulty;
import org.maproulette.client.model.ChallengePriority;
import org.maproulette.client.model.IMapRouletteObject;
import org.maproulette.client.model.RuleList;
import org.maproulette.client.utilities.Utilities;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Challenge
implements IMapRouletteObject,
Serializable {
    private static final long serialVersionUID = -8034692909431083341L;
    private static final int DEFAULT_ZOOM = 13;
    private static final int MINIMUM_ZOOM = 1;
    private static final int MAXIMUM_ZOOM = 19;
    private long id;
    private long parent;
    @NonNull
    private String instruction;
    private ChallengeDifficulty difficulty;
    private String blurb;
    private boolean enabled;
    private String description;
    private boolean featured;
    private String checkinComment;
    private String checkinSource;
    @NonNull
    private String name;
    private ChallengePriority defaultPriority;
    private RuleList highPriorityRule;
    private RuleList mediumPriorityRule;
    private RuleList lowPriorityRule;
    private int defaultZoom;
    private int minZoom;
    private int maxZoom;
    private Integer defaultBasemap;
    private String defaultBasemapId;
    private String customBasemap;
    private String preferredTags;
    private String preferredReviewTags;
    private String[] tags;
    private boolean changesetUrl;

    public static Challenge fromJson(String json) throws MapRouletteException {
        return Utilities.fromJson(json, Challenge.class);
    }

    private static long $default$id() {
        return -1L;
    }

    private static ChallengeDifficulty $default$difficulty() {
        return ChallengeDifficulty.NORMAL;
    }

    private static boolean $default$enabled() {
        return false;
    }

    private static boolean $default$featured() {
        return false;
    }

    private static String $default$checkinComment() {
        return "";
    }

    private static String $default$checkinSource() {
        return "";
    }

    private static ChallengePriority $default$defaultPriority() {
        return ChallengePriority.MEDIUM;
    }

    private static RuleList $default$highPriorityRule() {
        return RuleList.builder().build();
    }

    private static RuleList $default$mediumPriorityRule() {
        return RuleList.builder().build();
    }

    private static RuleList $default$lowPriorityRule() {
        return RuleList.builder().build();
    }

    private static int $default$defaultZoom() {
        return 13;
    }

    private static int $default$minZoom() {
        return 1;
    }

    private static int $default$maxZoom() {
        return 19;
    }

    private static boolean $default$changesetUrl() {
        return false;
    }

    public static ChallengeBuilder builder() {
        return new ChallengeBuilder();
    }

    public ChallengeBuilder toBuilder() {
        return new ChallengeBuilder().id(this.id).parent(this.parent).instruction(this.instruction).difficulty(this.difficulty).blurb(this.blurb).enabled(this.enabled).description(this.description).featured(this.featured).checkinComment(this.checkinComment).checkinSource(this.checkinSource).name(this.name).defaultPriority(this.defaultPriority).highPriorityRule(this.highPriorityRule).mediumPriorityRule(this.mediumPriorityRule).lowPriorityRule(this.lowPriorityRule).defaultZoom(this.defaultZoom).minZoom(this.minZoom).maxZoom(this.maxZoom).defaultBasemap(this.defaultBasemap).defaultBasemapId(this.defaultBasemapId).customBasemap(this.customBasemap).preferredTags(this.preferredTags).preferredReviewTags(this.preferredReviewTags).tags(this.tags).changesetUrl(this.changesetUrl);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public long getParent() {
        return this.parent;
    }

    @NonNull
    public String getInstruction() {
        return this.instruction;
    }

    public ChallengeDifficulty getDifficulty() {
        return this.difficulty;
    }

    public String getBlurb() {
        return this.blurb;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isFeatured() {
        return this.featured;
    }

    public String getCheckinComment() {
        return this.checkinComment;
    }

    public String getCheckinSource() {
        return this.checkinSource;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    public ChallengePriority getDefaultPriority() {
        return this.defaultPriority;
    }

    public RuleList getHighPriorityRule() {
        return this.highPriorityRule;
    }

    public RuleList getMediumPriorityRule() {
        return this.mediumPriorityRule;
    }

    public RuleList getLowPriorityRule() {
        return this.lowPriorityRule;
    }

    public int getDefaultZoom() {
        return this.defaultZoom;
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public Integer getDefaultBasemap() {
        return this.defaultBasemap;
    }

    public String getDefaultBasemapId() {
        return this.defaultBasemapId;
    }

    public String getCustomBasemap() {
        return this.customBasemap;
    }

    public String getPreferredTags() {
        return this.preferredTags;
    }

    public String getPreferredReviewTags() {
        return this.preferredReviewTags;
    }

    public String[] getTags() {
        return this.tags;
    }

    public boolean isChangesetUrl() {
        return this.changesetUrl;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setParent(long parent) {
        this.parent = parent;
    }

    public void setInstruction(@NonNull String instruction) {
        if (instruction == null) {
            throw new NullPointerException("instruction is marked non-null but is null");
        }
        this.instruction = instruction;
    }

    public void setDifficulty(ChallengeDifficulty difficulty) {
        this.difficulty = difficulty;
    }

    public void setBlurb(String blurb) {
        this.blurb = blurb;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFeatured(boolean featured) {
        this.featured = featured;
    }

    public void setCheckinComment(String checkinComment) {
        this.checkinComment = checkinComment;
    }

    public void setCheckinSource(String checkinSource) {
        this.checkinSource = checkinSource;
    }

    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public void setDefaultPriority(ChallengePriority defaultPriority) {
        this.defaultPriority = defaultPriority;
    }

    public void setHighPriorityRule(RuleList highPriorityRule) {
        this.highPriorityRule = highPriorityRule;
    }

    public void setMediumPriorityRule(RuleList mediumPriorityRule) {
        this.mediumPriorityRule = mediumPriorityRule;
    }

    public void setLowPriorityRule(RuleList lowPriorityRule) {
        this.lowPriorityRule = lowPriorityRule;
    }

    public void setDefaultZoom(int defaultZoom) {
        this.defaultZoom = defaultZoom;
    }

    public void setMinZoom(int minZoom) {
        this.minZoom = minZoom;
    }

    public void setMaxZoom(int maxZoom) {
        this.maxZoom = maxZoom;
    }

    public void setDefaultBasemap(Integer defaultBasemap) {
        this.defaultBasemap = defaultBasemap;
    }

    public void setDefaultBasemapId(String defaultBasemapId) {
        this.defaultBasemapId = defaultBasemapId;
    }

    public void setCustomBasemap(String customBasemap) {
        this.customBasemap = customBasemap;
    }

    public void setPreferredTags(String preferredTags) {
        this.preferredTags = preferredTags;
    }

    public void setPreferredReviewTags(String preferredReviewTags) {
        this.preferredReviewTags = preferredReviewTags;
    }

    public void setTags(String[] tags) {
        this.tags = tags;
    }

    public void setChangesetUrl(boolean changesetUrl) {
        this.changesetUrl = changesetUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Challenge)) {
            return false;
        }
        Challenge other = (Challenge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getParent() != other.getParent()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.isFeatured() != other.isFeatured()) {
            return false;
        }
        if (this.getDefaultZoom() != other.getDefaultZoom()) {
            return false;
        }
        if (this.getMinZoom() != other.getMinZoom()) {
            return false;
        }
        if (this.getMaxZoom() != other.getMaxZoom()) {
            return false;
        }
        if (this.isChangesetUrl() != other.isChangesetUrl()) {
            return false;
        }
        Integer this$defaultBasemap = this.getDefaultBasemap();
        Integer other$defaultBasemap = other.getDefaultBasemap();
        if (this$defaultBasemap == null ? other$defaultBasemap != null : !((Object)this$defaultBasemap).equals(other$defaultBasemap)) {
            return false;
        }
        String this$instruction = this.getInstruction();
        String other$instruction = other.getInstruction();
        if (this$instruction == null ? other$instruction != null : !this$instruction.equals(other$instruction)) {
            return false;
        }
        ChallengeDifficulty this$difficulty = this.getDifficulty();
        ChallengeDifficulty other$difficulty = other.getDifficulty();
        if (this$difficulty == null ? other$difficulty != null : !((Object)((Object)this$difficulty)).equals((Object)other$difficulty)) {
            return false;
        }
        String this$blurb = this.getBlurb();
        String other$blurb = other.getBlurb();
        if (this$blurb == null ? other$blurb != null : !this$blurb.equals(other$blurb)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$checkinComment = this.getCheckinComment();
        String other$checkinComment = other.getCheckinComment();
        if (this$checkinComment == null ? other$checkinComment != null : !this$checkinComment.equals(other$checkinComment)) {
            return false;
        }
        String this$checkinSource = this.getCheckinSource();
        String other$checkinSource = other.getCheckinSource();
        if (this$checkinSource == null ? other$checkinSource != null : !this$checkinSource.equals(other$checkinSource)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        ChallengePriority this$defaultPriority = this.getDefaultPriority();
        ChallengePriority other$defaultPriority = other.getDefaultPriority();
        if (this$defaultPriority == null ? other$defaultPriority != null : !((Object)((Object)this$defaultPriority)).equals((Object)other$defaultPriority)) {
            return false;
        }
        RuleList this$highPriorityRule = this.getHighPriorityRule();
        RuleList other$highPriorityRule = other.getHighPriorityRule();
        if (this$highPriorityRule == null ? other$highPriorityRule != null : !((Object)this$highPriorityRule).equals(other$highPriorityRule)) {
            return false;
        }
        RuleList this$mediumPriorityRule = this.getMediumPriorityRule();
        RuleList other$mediumPriorityRule = other.getMediumPriorityRule();
        if (this$mediumPriorityRule == null ? other$mediumPriorityRule != null : !((Object)this$mediumPriorityRule).equals(other$mediumPriorityRule)) {
            return false;
        }
        RuleList this$lowPriorityRule = this.getLowPriorityRule();
        RuleList other$lowPriorityRule = other.getLowPriorityRule();
        if (this$lowPriorityRule == null ? other$lowPriorityRule != null : !((Object)this$lowPriorityRule).equals(other$lowPriorityRule)) {
            return false;
        }
        String this$defaultBasemapId = this.getDefaultBasemapId();
        String other$defaultBasemapId = other.getDefaultBasemapId();
        if (this$defaultBasemapId == null ? other$defaultBasemapId != null : !this$defaultBasemapId.equals(other$defaultBasemapId)) {
            return false;
        }
        String this$customBasemap = this.getCustomBasemap();
        String other$customBasemap = other.getCustomBasemap();
        if (this$customBasemap == null ? other$customBasemap != null : !this$customBasemap.equals(other$customBasemap)) {
            return false;
        }
        String this$preferredTags = this.getPreferredTags();
        String other$preferredTags = other.getPreferredTags();
        if (this$preferredTags == null ? other$preferredTags != null : !this$preferredTags.equals(other$preferredTags)) {
            return false;
        }
        String this$preferredReviewTags = this.getPreferredReviewTags();
        String other$preferredReviewTags = other.getPreferredReviewTags();
        if (this$preferredReviewTags == null ? other$preferredReviewTags != null : !this$preferredReviewTags.equals(other$preferredReviewTags)) {
            return false;
        }
        return Arrays.deepEquals(this.getTags(), other.getTags());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Challenge;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        long $parent = this.getParent();
        result = result * 59 + (int)($parent >>> 32 ^ $parent);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + (this.isFeatured() ? 79 : 97);
        result = result * 59 + this.getDefaultZoom();
        result = result * 59 + this.getMinZoom();
        result = result * 59 + this.getMaxZoom();
        result = result * 59 + (this.isChangesetUrl() ? 79 : 97);
        Integer $defaultBasemap = this.getDefaultBasemap();
        result = result * 59 + ($defaultBasemap == null ? 43 : ((Object)$defaultBasemap).hashCode());
        String $instruction = this.getInstruction();
        result = result * 59 + ($instruction == null ? 43 : $instruction.hashCode());
        ChallengeDifficulty $difficulty = this.getDifficulty();
        result = result * 59 + ($difficulty == null ? 43 : ((Object)((Object)$difficulty)).hashCode());
        String $blurb = this.getBlurb();
        result = result * 59 + ($blurb == null ? 43 : $blurb.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $checkinComment = this.getCheckinComment();
        result = result * 59 + ($checkinComment == null ? 43 : $checkinComment.hashCode());
        String $checkinSource = this.getCheckinSource();
        result = result * 59 + ($checkinSource == null ? 43 : $checkinSource.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        ChallengePriority $defaultPriority = this.getDefaultPriority();
        result = result * 59 + ($defaultPriority == null ? 43 : ((Object)((Object)$defaultPriority)).hashCode());
        RuleList $highPriorityRule = this.getHighPriorityRule();
        result = result * 59 + ($highPriorityRule == null ? 43 : ((Object)$highPriorityRule).hashCode());
        RuleList $mediumPriorityRule = this.getMediumPriorityRule();
        result = result * 59 + ($mediumPriorityRule == null ? 43 : ((Object)$mediumPriorityRule).hashCode());
        RuleList $lowPriorityRule = this.getLowPriorityRule();
        result = result * 59 + ($lowPriorityRule == null ? 43 : ((Object)$lowPriorityRule).hashCode());
        String $defaultBasemapId = this.getDefaultBasemapId();
        result = result * 59 + ($defaultBasemapId == null ? 43 : $defaultBasemapId.hashCode());
        String $customBasemap = this.getCustomBasemap();
        result = result * 59 + ($customBasemap == null ? 43 : $customBasemap.hashCode());
        String $preferredTags = this.getPreferredTags();
        result = result * 59 + ($preferredTags == null ? 43 : $preferredTags.hashCode());
        String $preferredReviewTags = this.getPreferredReviewTags();
        result = result * 59 + ($preferredReviewTags == null ? 43 : $preferredReviewTags.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTags());
        return result;
    }

    public String toString() {
        return "Challenge(id=" + this.getId() + ", parent=" + this.getParent() + ", instruction=" + this.getInstruction() + ", difficulty=" + this.getDifficulty() + ", blurb=" + this.getBlurb() + ", enabled=" + this.isEnabled() + ", description=" + this.getDescription() + ", featured=" + this.isFeatured() + ", checkinComment=" + this.getCheckinComment() + ", checkinSource=" + this.getCheckinSource() + ", name=" + this.getName() + ", defaultPriority=" + this.getDefaultPriority() + ", highPriorityRule=" + this.getHighPriorityRule() + ", mediumPriorityRule=" + this.getMediumPriorityRule() + ", lowPriorityRule=" + this.getLowPriorityRule() + ", defaultZoom=" + this.getDefaultZoom() + ", minZoom=" + this.getMinZoom() + ", maxZoom=" + this.getMaxZoom() + ", defaultBasemap=" + this.getDefaultBasemap() + ", defaultBasemapId=" + this.getDefaultBasemapId() + ", customBasemap=" + this.getCustomBasemap() + ", preferredTags=" + this.getPreferredTags() + ", preferredReviewTags=" + this.getPreferredReviewTags() + ", tags=" + Arrays.deepToString(this.getTags()) + ", changesetUrl=" + this.isChangesetUrl() + ")";
    }

    public Challenge() {
        this.id = Challenge.$default$id();
        this.difficulty = Challenge.$default$difficulty();
        this.enabled = Challenge.$default$enabled();
        this.featured = Challenge.$default$featured();
        this.checkinComment = Challenge.$default$checkinComment();
        this.checkinSource = Challenge.$default$checkinSource();
        this.defaultPriority = Challenge.$default$defaultPriority();
        this.highPriorityRule = Challenge.$default$highPriorityRule();
        this.mediumPriorityRule = Challenge.$default$mediumPriorityRule();
        this.lowPriorityRule = Challenge.$default$lowPriorityRule();
        this.defaultZoom = Challenge.$default$defaultZoom();
        this.minZoom = Challenge.$default$minZoom();
        this.maxZoom = Challenge.$default$maxZoom();
        this.changesetUrl = Challenge.$default$changesetUrl();
    }

    public Challenge(long id, long parent, @NonNull String instruction, ChallengeDifficulty difficulty, String blurb, boolean enabled, String description, boolean featured, String checkinComment, String checkinSource, @NonNull String name, ChallengePriority defaultPriority, RuleList highPriorityRule, RuleList mediumPriorityRule, RuleList lowPriorityRule, int defaultZoom, int minZoom, int maxZoom, Integer defaultBasemap, String defaultBasemapId, String customBasemap, String preferredTags, String preferredReviewTags, String[] tags, boolean changesetUrl) {
        if (instruction == null) {
            throw new NullPointerException("instruction is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.id = id;
        this.parent = parent;
        this.instruction = instruction;
        this.difficulty = difficulty;
        this.blurb = blurb;
        this.enabled = enabled;
        this.description = description;
        this.featured = featured;
        this.checkinComment = checkinComment;
        this.checkinSource = checkinSource;
        this.name = name;
        this.defaultPriority = defaultPriority;
        this.highPriorityRule = highPriorityRule;
        this.mediumPriorityRule = mediumPriorityRule;
        this.lowPriorityRule = lowPriorityRule;
        this.defaultZoom = defaultZoom;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.defaultBasemap = defaultBasemap;
        this.defaultBasemapId = defaultBasemapId;
        this.customBasemap = customBasemap;
        this.preferredTags = preferredTags;
        this.preferredReviewTags = preferredReviewTags;
        this.tags = tags;
        this.changesetUrl = changesetUrl;
    }

    public static class ChallengeBuilder {
        private boolean id$set;
        private long id$value;
        private long parent;
        private String instruction;
        private boolean difficulty$set;
        private ChallengeDifficulty difficulty$value;
        private String blurb;
        private boolean enabled$set;
        private boolean enabled$value;
        private String description;
        private boolean featured$set;
        private boolean featured$value;
        private boolean checkinComment$set;
        private String checkinComment$value;
        private boolean checkinSource$set;
        private String checkinSource$value;
        private String name;
        private boolean defaultPriority$set;
        private ChallengePriority defaultPriority$value;
        private boolean highPriorityRule$set;
        private RuleList highPriorityRule$value;
        private boolean mediumPriorityRule$set;
        private RuleList mediumPriorityRule$value;
        private boolean lowPriorityRule$set;
        private RuleList lowPriorityRule$value;
        private boolean defaultZoom$set;
        private int defaultZoom$value;
        private boolean minZoom$set;
        private int minZoom$value;
        private boolean maxZoom$set;
        private int maxZoom$value;
        private Integer defaultBasemap;
        private String defaultBasemapId;
        private String customBasemap;
        private String preferredTags;
        private String preferredReviewTags;
        private String[] tags;
        private boolean changesetUrl$set;
        private boolean changesetUrl$value;

        ChallengeBuilder() {
        }

        public ChallengeBuilder id(long id) {
            this.id$value = id;
            this.id$set = true;
            return this;
        }

        public ChallengeBuilder parent(long parent) {
            this.parent = parent;
            return this;
        }

        public ChallengeBuilder instruction(@NonNull String instruction) {
            if (instruction == null) {
                throw new NullPointerException("instruction is marked non-null but is null");
            }
            this.instruction = instruction;
            return this;
        }

        public ChallengeBuilder difficulty(ChallengeDifficulty difficulty) {
            this.difficulty$value = difficulty;
            this.difficulty$set = true;
            return this;
        }

        public ChallengeBuilder blurb(String blurb) {
            this.blurb = blurb;
            return this;
        }

        public ChallengeBuilder enabled(boolean enabled) {
            this.enabled$value = enabled;
            this.enabled$set = true;
            return this;
        }

        public ChallengeBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ChallengeBuilder featured(boolean featured) {
            this.featured$value = featured;
            this.featured$set = true;
            return this;
        }

        public ChallengeBuilder checkinComment(String checkinComment) {
            this.checkinComment$value = checkinComment;
            this.checkinComment$set = true;
            return this;
        }

        public ChallengeBuilder checkinSource(String checkinSource) {
            this.checkinSource$value = checkinSource;
            this.checkinSource$set = true;
            return this;
        }

        public ChallengeBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public ChallengeBuilder defaultPriority(ChallengePriority defaultPriority) {
            this.defaultPriority$value = defaultPriority;
            this.defaultPriority$set = true;
            return this;
        }

        public ChallengeBuilder highPriorityRule(RuleList highPriorityRule) {
            this.highPriorityRule$value = highPriorityRule;
            this.highPriorityRule$set = true;
            return this;
        }

        public ChallengeBuilder mediumPriorityRule(RuleList mediumPriorityRule) {
            this.mediumPriorityRule$value = mediumPriorityRule;
            this.mediumPriorityRule$set = true;
            return this;
        }

        public ChallengeBuilder lowPriorityRule(RuleList lowPriorityRule) {
            this.lowPriorityRule$value = lowPriorityRule;
            this.lowPriorityRule$set = true;
            return this;
        }

        public ChallengeBuilder defaultZoom(int defaultZoom) {
            this.defaultZoom$value = defaultZoom;
            this.defaultZoom$set = true;
            return this;
        }

        public ChallengeBuilder minZoom(int minZoom) {
            this.minZoom$value = minZoom;
            this.minZoom$set = true;
            return this;
        }

        public ChallengeBuilder maxZoom(int maxZoom) {
            this.maxZoom$value = maxZoom;
            this.maxZoom$set = true;
            return this;
        }

        public ChallengeBuilder defaultBasemap(Integer defaultBasemap) {
            this.defaultBasemap = defaultBasemap;
            return this;
        }

        public ChallengeBuilder defaultBasemapId(String defaultBasemapId) {
            this.defaultBasemapId = defaultBasemapId;
            return this;
        }

        public ChallengeBuilder customBasemap(String customBasemap) {
            this.customBasemap = customBasemap;
            return this;
        }

        public ChallengeBuilder preferredTags(String preferredTags) {
            this.preferredTags = preferredTags;
            return this;
        }

        public ChallengeBuilder preferredReviewTags(String preferredReviewTags) {
            this.preferredReviewTags = preferredReviewTags;
            return this;
        }

        public ChallengeBuilder tags(String[] tags) {
            this.tags = tags;
            return this;
        }

        public ChallengeBuilder changesetUrl(boolean changesetUrl) {
            this.changesetUrl$value = changesetUrl;
            this.changesetUrl$set = true;
            return this;
        }

        public Challenge build() {
            long id$value = this.id$value;
            if (!this.id$set) {
                id$value = Challenge.$default$id();
            }
            ChallengeDifficulty difficulty$value = this.difficulty$value;
            if (!this.difficulty$set) {
                difficulty$value = Challenge.$default$difficulty();
            }
            boolean enabled$value = this.enabled$value;
            if (!this.enabled$set) {
                enabled$value = Challenge.$default$enabled();
            }
            boolean featured$value = this.featured$value;
            if (!this.featured$set) {
                featured$value = Challenge.$default$featured();
            }
            String checkinComment$value = this.checkinComment$value;
            if (!this.checkinComment$set) {
                checkinComment$value = Challenge.$default$checkinComment();
            }
            String checkinSource$value = this.checkinSource$value;
            if (!this.checkinSource$set) {
                checkinSource$value = Challenge.$default$checkinSource();
            }
            ChallengePriority defaultPriority$value = this.defaultPriority$value;
            if (!this.defaultPriority$set) {
                defaultPriority$value = Challenge.$default$defaultPriority();
            }
            RuleList highPriorityRule$value = this.highPriorityRule$value;
            if (!this.highPriorityRule$set) {
                highPriorityRule$value = Challenge.$default$highPriorityRule();
            }
            RuleList mediumPriorityRule$value = this.mediumPriorityRule$value;
            if (!this.mediumPriorityRule$set) {
                mediumPriorityRule$value = Challenge.$default$mediumPriorityRule();
            }
            RuleList lowPriorityRule$value = this.lowPriorityRule$value;
            if (!this.lowPriorityRule$set) {
                lowPriorityRule$value = Challenge.$default$lowPriorityRule();
            }
            int defaultZoom$value = this.defaultZoom$value;
            if (!this.defaultZoom$set) {
                defaultZoom$value = Challenge.$default$defaultZoom();
            }
            int minZoom$value = this.minZoom$value;
            if (!this.minZoom$set) {
                minZoom$value = Challenge.$default$minZoom();
            }
            int maxZoom$value = this.maxZoom$value;
            if (!this.maxZoom$set) {
                maxZoom$value = Challenge.$default$maxZoom();
            }
            boolean changesetUrl$value = this.changesetUrl$value;
            if (!this.changesetUrl$set) {
                changesetUrl$value = Challenge.$default$changesetUrl();
            }
            return new Challenge(id$value, this.parent, this.instruction, difficulty$value, this.blurb, enabled$value, this.description, featured$value, checkinComment$value, checkinSource$value, this.name, defaultPriority$value, highPriorityRule$value, mediumPriorityRule$value, lowPriorityRule$value, defaultZoom$value, minZoom$value, maxZoom$value, this.defaultBasemap, this.defaultBasemapId, this.customBasemap, this.preferredTags, this.preferredReviewTags, this.tags, changesetUrl$value);
        }

        public String toString() {
            return "Challenge.ChallengeBuilder(id$value=" + this.id$value + ", parent=" + this.parent + ", instruction=" + this.instruction + ", difficulty$value=" + this.difficulty$value + ", blurb=" + this.blurb + ", enabled$value=" + this.enabled$value + ", description=" + this.description + ", featured$value=" + this.featured$value + ", checkinComment$value=" + this.checkinComment$value + ", checkinSource$value=" + this.checkinSource$value + ", name=" + this.name + ", defaultPriority$value=" + this.defaultPriority$value + ", highPriorityRule$value=" + this.highPriorityRule$value + ", mediumPriorityRule$value=" + this.mediumPriorityRule$value + ", lowPriorityRule$value=" + this.lowPriorityRule$value + ", defaultZoom$value=" + this.defaultZoom$value + ", minZoom$value=" + this.minZoom$value + ", maxZoom$value=" + this.maxZoom$value + ", defaultBasemap=" + this.defaultBasemap + ", defaultBasemapId=" + this.defaultBasemapId + ", customBasemap=" + this.customBasemap + ", preferredTags=" + this.preferredTags + ", preferredReviewTags=" + this.preferredReviewTags + ", tags=" + Arrays.deepToString(this.tags) + ", changesetUrl$value=" + this.changesetUrl$value + ")";
        }
    }
}

