/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.maproulette.client.exception.MapRouletteException;
import org.maproulette.client.exception.MapRouletteRuntimeException;
import org.maproulette.client.model.ChallengePriority;
import org.maproulette.client.model.IMapRouletteObject;
import org.maproulette.client.model.PointInformation;
import org.maproulette.client.model.TaskStatus;
import org.maproulette.client.utilities.ObjectMapperSingleton;
import org.maproulette.client.utilities.Utilities;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Task
implements IMapRouletteObject,
Serializable {
    private static final int CONSTANT_HASHCODE = 31;
    private static final long serialVersionUID = 3111348272637323920L;
    private long id;
    private long parent;
    private String name;
    private String instruction;
    private JsonNode location;
    private TaskStatus status;
    private ChallengePriority priority;
    private JsonNode geometries;
    private List<String> tags;
    private Long completedBy;
    private Long completedTimeSpent;
    private String mappedOn;
    private String errorTags;

    public static TaskBuilder builder(long parentIdentifier, String name) {
        return Task.taskBuilder().parent(parentIdentifier).name(name);
    }

    public static Task fromJson(String json) throws MapRouletteException {
        return Utilities.fromJson(json, Task.class);
    }

    public TaskBuilder toBuilder(boolean resetGeometry) {
        if (resetGeometry) {
            return this.toBuilder().resetGeometry();
        }
        return this.toBuilder();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Task) {
            Task task2 = (Task)obj;
            if (this.getId() == -1L || task2.getId() == -1L) {
                return StringUtils.equals((String)this.name, (String)task2.getName()) && this.getParent() == task2.getParent();
            }
            if (this.getId() == task2.getId()) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.id != -1L) {
            return Long.hashCode(this.id);
        }
        int result = 31 + this.name.hashCode();
        return 31 * result + Long.hashCode(this.parent);
    }

    public static TaskBuilder taskBuilder() {
        return new TaskBuilder();
    }

    public TaskBuilder toBuilder() {
        return new TaskBuilder().id(this.id).parent(this.parent).name(this.name).instruction(this.instruction).location(this.location).status(this.status).priority(this.priority).geometries(this.geometries).tags(this.tags).completedBy(this.completedBy).completedTimeSpent(this.completedTimeSpent).mappedOn(this.mappedOn).errorTags(this.errorTags);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public long getParent() {
        return this.parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public JsonNode getLocation() {
        return this.location;
    }

    public TaskStatus getStatus() {
        return this.status;
    }

    public ChallengePriority getPriority() {
        return this.priority;
    }

    public JsonNode getGeometries() {
        return this.geometries;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Long getCompletedBy() {
        return this.completedBy;
    }

    public Long getCompletedTimeSpent() {
        return this.completedTimeSpent;
    }

    public String getMappedOn() {
        return this.mappedOn;
    }

    public String getErrorTags() {
        return this.errorTags;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setParent(long parent) {
        this.parent = parent;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public void setLocation(JsonNode location) {
        this.location = location;
    }

    public void setStatus(TaskStatus status) {
        this.status = status;
    }

    public void setPriority(ChallengePriority priority) {
        this.priority = priority;
    }

    public void setGeometries(JsonNode geometries) {
        this.geometries = geometries;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setCompletedBy(Long completedBy) {
        this.completedBy = completedBy;
    }

    public void setCompletedTimeSpent(Long completedTimeSpent) {
        this.completedTimeSpent = completedTimeSpent;
    }

    public void setMappedOn(String mappedOn) {
        this.mappedOn = mappedOn;
    }

    public void setErrorTags(String errorTags) {
        this.errorTags = errorTags;
    }

    public String toString() {
        return "Task(id=" + this.getId() + ", parent=" + this.getParent() + ", name=" + this.getName() + ", instruction=" + this.getInstruction() + ", location=" + this.getLocation() + ", status=" + this.getStatus() + ", priority=" + this.getPriority() + ", geometries=" + this.getGeometries() + ", tags=" + this.getTags() + ", completedBy=" + this.getCompletedBy() + ", completedTimeSpent=" + this.getCompletedTimeSpent() + ", mappedOn=" + this.getMappedOn() + ", errorTags=" + this.getErrorTags() + ")";
    }

    public Task() {
    }

    public Task(long id, long parent, String name, String instruction, JsonNode location, TaskStatus status, ChallengePriority priority, JsonNode geometries, List<String> tags, Long completedBy, Long completedTimeSpent, String mappedOn, String errorTags) {
        this.id = id;
        this.parent = parent;
        this.name = name;
        this.instruction = instruction;
        this.location = location;
        this.status = status;
        this.priority = priority;
        this.geometries = geometries;
        this.tags = tags;
        this.completedBy = completedBy;
        this.completedTimeSpent = completedTimeSpent;
        this.mappedOn = mappedOn;
        this.errorTags = errorTags;
    }

    public static class TaskBuilder {
        private long id;
        private long parent;
        private String name;
        private String instruction;
        private JsonNode location;
        private TaskStatus status;
        private ChallengePriority priority;
        private JsonNode geometries;
        private List<String> tags;
        private Long completedBy;
        private Long completedTimeSpent;
        private String mappedOn;
        private String errorTags;
        private static final String TASK_TYPE = "type";
        private static final String TASK_FEATURES = "features";
        private static final String TASK_FEATURE_COORDINATES = "coordinates";
        private static final String TASK_FEATURE_GEOMETRY = "geometry";
        private static final String KEY_DESCRIPTION = "description";
        private static final String TASK_FEATURE_PROPERTIES = "properties";
        private static final String FEATURE = "feature";
        private static final String POINT = "point";
        private final ObjectMapper mapper = ObjectMapperSingleton.getMapper();
        private final Set<PointInformation> points = new HashSet<PointInformation>();
        private ArrayNode geoJson = this.mapper.createArrayNode();

        public TaskBuilder locationGeojson(String geojson) {
            try {
                this.location = this.mapper.readTree(geojson);
            }
            catch (IOException e) {
                throw new MapRouletteRuntimeException(e);
            }
            return this;
        }

        public TaskBuilder addPoint(PointInformation point) {
            this.points.add(point);
            return this;
        }

        public TaskBuilder addPoints(List<PointInformation> points) {
            this.points.addAll(points);
            return this;
        }

        public TaskBuilder addGeojson(String geojson) {
            try {
                this.geoJson.add(this.mapper.readTree(geojson));
            }
            catch (IOException e) {
                throw new MapRouletteRuntimeException(e);
            }
            return this;
        }

        public TaskBuilder addErrorTags(String errorTags) {
            this.errorTags = errorTags;
            return this;
        }

        public TaskBuilder resetGeometry() {
            this.geoJson = this.mapper.createArrayNode();
            this.geometries = null;
            return this;
        }

        public TaskBuilder addGeojson(List<String> geojson) {
            geojson.forEach(arg_0 -> ((ArrayNode)this.geoJson).add(arg_0));
            return this;
        }

        public Task build() {
            try {
                if (this.geometries == null) {
                    this.geometries(this.buildGeometries());
                }
            }
            catch (MapRouletteException e) {
                throw new MapRouletteRuntimeException(e);
            }
            if (this.id < 1L) {
                this.id(-1L);
            }
            if (this.parent < 1L) {
                this.parent(-1L);
            }
            if (this.errorTags == null) {
                this.errorTags = "";
            }
            return new Task(this.id, this.parent, this.name, this.instruction, this.location, this.status, this.priority, this.geometries, this.tags, null, null, null, this.errorTags);
        }

        protected ArrayNode generateTaskFeatures(Set<PointInformation> source, ArrayNode geoJson) throws MapRouletteException {
            ArrayNode features = this.mapper.createArrayNode();
            if (source.isEmpty() && geoJson.size() == 0) {
                throw new MapRouletteException(String.format("Could not find any features for the task [%s].", this.toString()));
            }
            source.forEach(point -> {
                ObjectNode feature = this.mapper.createObjectNode();
                ObjectNode geometry = this.mapper.createObjectNode();
                ArrayNode coordinates = this.mapper.createArrayNode();
                coordinates.add(point.getLongitude());
                coordinates.add(point.getLatitude());
                geometry.put(TASK_TYPE, POINT);
                geometry.set(TASK_FEATURE_COORDINATES, (JsonNode)coordinates);
                feature.set(TASK_FEATURE_GEOMETRY, (JsonNode)geometry);
                feature.put(TASK_TYPE, FEATURE);
                ObjectNode pointInformation = this.mapper.createObjectNode();
                if (StringUtils.isEmpty((String)point.getDescription())) {
                    pointInformation.put(KEY_DESCRIPTION, point.getDescription());
                }
                feature.set(TASK_FEATURE_PROPERTIES, (JsonNode)pointInformation);
                features.add((JsonNode)feature);
            });
            if (geoJson != null) {
                geoJson.forEach(arg_0 -> ((ArrayNode)features).add(arg_0));
            }
            return features;
        }

        private TaskBuilder location(JsonNode value) {
            this.location = value;
            return this;
        }

        private TaskBuilder geometries(JsonNode value) {
            this.geometries = value;
            return this;
        }

        private JsonNode buildGeometries() throws MapRouletteException {
            ObjectNode result = this.mapper.createObjectNode();
            result.set(TASK_FEATURES, (JsonNode)this.generateTaskFeatures(this.points, this.geoJson));
            return result;
        }

        TaskBuilder() {
        }

        public TaskBuilder id(long id) {
            this.id = id;
            return this;
        }

        public TaskBuilder parent(long parent) {
            this.parent = parent;
            return this;
        }

        public TaskBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TaskBuilder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        public TaskBuilder status(TaskStatus status) {
            this.status = status;
            return this;
        }

        public TaskBuilder priority(ChallengePriority priority) {
            this.priority = priority;
            return this;
        }

        public TaskBuilder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public TaskBuilder completedBy(Long completedBy) {
            this.completedBy = completedBy;
            return this;
        }

        public TaskBuilder completedTimeSpent(Long completedTimeSpent) {
            this.completedTimeSpent = completedTimeSpent;
            return this;
        }

        public TaskBuilder mappedOn(String mappedOn) {
            this.mappedOn = mappedOn;
            return this;
        }

        public TaskBuilder errorTags(String errorTags) {
            this.errorTags = errorTags;
            return this;
        }

        public String toString() {
            return "Task.TaskBuilder(id=" + this.id + ", parent=" + this.parent + ", name=" + this.name + ", instruction=" + this.instruction + ", location=" + this.location + ", status=" + this.status + ", priority=" + this.priority + ", geometries=" + this.geometries + ", tags=" + this.tags + ", completedBy=" + this.completedBy + ", completedTimeSpent=" + this.completedTimeSpent + ", mappedOn=" + this.mappedOn + ", errorTags=" + this.errorTags + ")";
        }
    }
}

