/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang.StringUtils;

public enum ChallengeDifficulty {
    EASY(1),
    NORMAL(2),
    EXPERT(3);

    private final int value;

    @JsonCreator
    public static ChallengeDifficulty fromValue(String value) {
        try {
            int intValue = Integer.parseInt(value);
            return ChallengeDifficulty.fromValue(intValue);
        }
        catch (NumberFormatException e) {
            for (ChallengeDifficulty challengeDifficulty : ChallengeDifficulty.values()) {
                if (!StringUtils.equalsIgnoreCase((String)challengeDifficulty.name(), (String)value)) continue;
                return challengeDifficulty;
            }
            return null;
        }
    }

    public static ChallengeDifficulty fromValue(int value) {
        for (ChallengeDifficulty challengeDifficulty : ChallengeDifficulty.values()) {
            if (challengeDifficulty.intValue() != value) continue;
            return challengeDifficulty;
        }
        return null;
    }

    private ChallengeDifficulty(int value) {
        this.value = value;
    }

    @JsonValue
    public int intValue() {
        return this.value;
    }
}

