/*
 * Decompiled with CFR 0.152.
 */
package org.maproulette.client.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import lombok.NonNull;
import org.maproulette.client.exception.MapRouletteException;
import org.maproulette.client.model.IMapRouletteObject;
import org.maproulette.client.utilities.Utilities;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Project
implements IMapRouletteObject,
Serializable {
    private static final long serialVersionUID = 6310166267361870242L;
    private long id;
    @NonNull
    private String name;
    private String description;
    private String displayName;
    private boolean enabled;

    public static Project fromJson(String json) throws MapRouletteException {
        return Utilities.fromJson(json, Project.class);
    }

    @Override
    public long getParent() {
        return -1L;
    }

    private static long $default$id() {
        return -1L;
    }

    private static boolean $default$enabled() {
        return false;
    }

    public static ProjectBuilder builder() {
        return new ProjectBuilder();
    }

    public ProjectBuilder toBuilder() {
        return new ProjectBuilder().id(this.id).name(this.name).description(this.description).displayName(this.displayName).enabled(this.enabled);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Project)) {
            return false;
        }
        Project other = (Project)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Project;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        return result;
    }

    public String toString() {
        return "Project(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", displayName=" + this.getDisplayName() + ", enabled=" + this.isEnabled() + ")";
    }

    public Project() {
        this.id = Project.$default$id();
        this.enabled = Project.$default$enabled();
    }

    public Project(long id, @NonNull String name, String description, String displayName, boolean enabled) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.id = id;
        this.name = name;
        this.description = description;
        this.displayName = displayName;
        this.enabled = enabled;
    }

    public void setId(long id) {
        this.id = id;
    }

    public static class ProjectBuilder {
        private boolean id$set;
        private long id$value;
        private String name;
        private String description;
        private String displayName;
        private boolean enabled$set;
        private boolean enabled$value;

        ProjectBuilder() {
        }

        public ProjectBuilder id(long id) {
            this.id$value = id;
            this.id$set = true;
            return this;
        }

        public ProjectBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public ProjectBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ProjectBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public ProjectBuilder enabled(boolean enabled) {
            this.enabled$value = enabled;
            this.enabled$set = true;
            return this;
        }

        public Project build() {
            long id$value = this.id$value;
            if (!this.id$set) {
                id$value = Project.$default$id();
            }
            boolean enabled$value = this.enabled$value;
            if (!this.enabled$set) {
                enabled$value = Project.$default$enabled();
            }
            return new Project(id$value, this.name, this.description, this.displayName, enabled$value);
        }

        public String toString() {
            return "Project.ProjectBuilder(id$value=" + this.id$value + ", name=" + this.name + ", description=" + this.description + ", displayName=" + this.displayName + ", enabled$value=" + this.enabled$value + ")";
        }
    }
}

