/*
 * Decompiled with CFR 0.152.
 */
package pixela.client.impl;

import java.io.UncheckedIOException;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

final class Exceptions {
    private Exceptions() {
    }

    @NotNull
    @Contract(pure=true)
    static Function<Throwable, Void> asFunction(Consumer<Throwable> consumer) {
        return t -> {
            if (t instanceof CompletionException) {
                Throwable cause = t.getCause();
                if (cause instanceof UncheckedIOException) {
                    Throwable ioe = cause.getCause();
                    consumer.accept(ioe);
                } else {
                    consumer.accept(cause);
                }
            } else {
                consumer.accept((Throwable)t);
            }
            return null;
        };
    }
}

