/*
 * Decompiled with CFR 0.152.
 */
package pixela.client.impl;

import java.net.URI;
import java.net.http.HttpRequest;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import pixela.client.AutoCloseables;
import pixela.client.PixelaClientConfig;
import pixela.client.http.Delete;
import pixela.client.http.Get;
import pixela.client.http.HttpClient;
import pixela.client.http.HttpResponse;
import pixela.client.http.Post;
import pixela.client.http.Put;
import pixela.client.http.json.JsonCodec;
import pixela.client.http.json.JsonCodecFactory;
import pixela.client.http.json.JsonDecoder;
import pixela.client.http.json.JsonEncoder;
import pixela.client.impl.JdkHttpClient;
import pixela.client.impl.JdkRequestBuilder;
import pixela.client.impl.SupplierExecutor;
import reactor.core.publisher.Mono;

class HttpClientImpl
implements HttpClient {
    @NotNull
    private final AutoCloseable executors;
    @NotNull
    private final JdkHttpClient httpClient;
    @NotNull
    private final JdkRequestBuilder jdkRequestBuilder;
    @NotNull
    private final SupplierExecutor executor;

    HttpClientImpl(@NotNull PixelaClientConfig config) {
        ExecutorService executorServiceForJackson = Executors.newSingleThreadExecutor();
        ExecutorService executorServiceForHttpClient = Executors.newFixedThreadPool(config.getThreadsNum());
        AutoCloseable[] autoCloseableArray = new AutoCloseable[2];
        autoCloseableArray[0] = executorServiceForHttpClient::shutdown;
        autoCloseableArray[1] = executorServiceForJackson::shutdown;
        this.executors = AutoCloseables.of((AutoCloseable[])autoCloseableArray);
        JsonCodec codec = JsonCodecFactory.getInstance().create(executorServiceForJackson);
        this.httpClient = JdkHttpClient.create(executorServiceForHttpClient, (JsonDecoder)codec, config);
        this.jdkRequestBuilder = JdkRequestBuilder.create(config.baseUri(), (JsonEncoder)codec);
        this.executor = SupplierExecutor.fromExecutorService(executorServiceForHttpClient);
    }

    HttpClientImpl(@NotNull AutoCloseable executors, @NotNull JdkHttpClient httpClient, @NotNull JdkRequestBuilder jdkRequestBuilder) {
        this.executors = executors;
        this.httpClient = httpClient;
        this.jdkRequestBuilder = jdkRequestBuilder;
        this.executor = SupplierExecutor.noExecutor();
    }

    @NotNull
    public Mono<String> encodeJson(@NotNull Object object) {
        return this.jdkRequestBuilder.encodeJson(object);
    }

    @NotNull
    public JsonEncoder encoder() {
        return this.jdkRequestBuilder::encodeJson;
    }

    @NotNull
    public <T> Mono<T> decodeJson(@NotNull String json, @NotNull Class<T> type) {
        return this.httpClient.decodeJson(json, type);
    }

    @NotNull
    public JsonDecoder decoder() {
        return this.httpClient::decodeJson;
    }

    @NotNull
    public <T> Mono<T> runAsync(@NotNull Supplier<? extends T> supplier) {
        return this.executor.runSupplier(supplier);
    }

    @NotNull
    public URI baseUri() {
        return this.jdkRequestBuilder.baseUri();
    }

    @NotNull
    public <T> Mono<HttpResponse> runGet(@NotNull Get<T> getRequest) {
        Mono<HttpRequest> httpRequest = this.jdkRequestBuilder.get(getRequest);
        return httpRequest.flatMap(this.httpClient::sendRequest);
    }

    @NotNull
    public <T> Mono<HttpResponse> runPost(@NotNull Post<T> postRequest) {
        Mono<HttpRequest> httpRequest = this.jdkRequestBuilder.post(postRequest);
        return httpRequest.flatMap(this.httpClient::sendRequest);
    }

    @NotNull
    public <T> Mono<HttpResponse> runPut(@NotNull Put<T> putRequest) {
        Mono<HttpRequest> httpRequest = this.jdkRequestBuilder.put(putRequest);
        return httpRequest.flatMap(this.httpClient::sendRequest);
    }

    @NotNull
    public <T> Mono<HttpResponse> runDelete(@NotNull Delete<T> deleteRequest) {
        Mono<HttpRequest> delete = this.jdkRequestBuilder.delete(deleteRequest);
        return delete.flatMap(this.httpClient::sendRequest);
    }

    public void close() throws Exception {
        this.executors.close();
    }
}

