/*
 * Decompiled with CFR 0.152.
 */
package pixela.client.impl;

import java.net.URI;
import java.net.http.HttpRequest;
import org.jetbrains.annotations.NotNull;
import pixela.client.http.Delete;
import pixela.client.impl.RequestBuilder;
import pixela.client.impl.UserTokenHeader;
import reactor.core.publisher.Mono;

class JdkDeleteRequestBuilder
implements RequestBuilder<Delete<?>> {
    @NotNull
    private final URI baseUri;

    private JdkDeleteRequestBuilder(@NotNull URI baseUri) {
        this.baseUri = baseUri;
    }

    @NotNull
    static JdkDeleteRequestBuilder of(@NotNull URI baseUri) {
        return new JdkDeleteRequestBuilder(baseUri);
    }

    @Override
    @NotNull
    public Mono<HttpRequest> apply(@NotNull Delete<?> delete) {
        URI uri = delete.apiEndpoint(this.baseUri);
        HttpRequest.Builder builder = HttpRequest.newBuilder(uri).DELETE();
        HttpRequest request = UserTokenHeader.of(delete).configure(builder).build();
        return Mono.just((Object)request);
    }
}

