/*
 * Decompiled with CFR 0.152.
 */
package pixela.client.impl;

import java.net.URI;
import java.net.http.HttpRequest;
import org.jetbrains.annotations.NotNull;
import pixela.client.http.Get;
import pixela.client.impl.RequestBuilder;
import pixela.client.impl.UserTokenHeader;
import reactor.core.publisher.Mono;

class JdkGetRequestBuilder
implements RequestBuilder<Get<?>> {
    @NotNull
    private final URI baseUri;

    private JdkGetRequestBuilder(@NotNull URI baseUri) {
        this.baseUri = baseUri;
    }

    static JdkGetRequestBuilder of(@NotNull URI baseUri) {
        return new JdkGetRequestBuilder(baseUri);
    }

    @Override
    @NotNull
    public Mono<HttpRequest> apply(@NotNull Get<?> get) {
        URI uri = get.apiEndpoint(this.baseUri);
        HttpRequest.Builder builder = HttpRequest.newBuilder(uri).GET();
        HttpRequest request = UserTokenHeader.of(get).configure(builder).build();
        return Mono.just((Object)request);
    }
}

