/*
 * Decompiled with CFR 0.152.
 */
package pixela.client.impl;

import java.net.http.HttpRequest;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import pixela.client.http.Request;
import pixela.client.impl.Header;

class ContentTypeHeader
implements Header<HttpRequest.Builder> {
    @NotNull
    private final Request<?> request;

    private ContentTypeHeader(@NotNull Request<?> request) {
        this.request = request;
    }

    static ContentTypeHeader of(@NotNull Request<?> request) {
        return new ContentTypeHeader(request);
    }

    @Override
    @NotNull
    public HttpRequest.Builder configure(@NotNull HttpRequest.Builder targetObject) {
        Optional contentType = this.request.contentType();
        return contentType.map(type -> targetObject.header("Content-Type", (String)type)).orElse(targetObject);
    }
}

